/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.rowcreator.impl;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.seasar.robot.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.robot.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.robot.dbflute.s2dao.metadata.TnRelationPropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnRelationRowCreationResource {
    protected ResultSet resultSet;
    protected Object row;
    protected TnRelationPropertyType relationPropertyType;
    protected Set<String> columnNames;
    protected Map<String, Object> relKeyValues;
    protected Map<String, Map<String, TnPropertyType>> relationPropertyCache;
    protected String baseSuffix;
    protected String relationNoSuffix;
    protected int limitRelationNestLevel;
    protected int currentRelationNestLevel;
    protected TnPropertyType currentPropertyType;
    protected int validValueCount;
    protected boolean createDeadLink;
    protected Stack<TnRelationPropertyType> relationPropertyTypeBackup;
    protected Stack<String> baseSuffixBackup;
    protected Stack<String> relationSuffixBackup;
    protected Map<String, Integer> _selectIndexMap;

    public boolean hasRowInstance() {
        return this.row != null;
    }

    public void clearRowInstance() {
        this.row = null;
    }

    public TnBeanMetaData getRelationBeanMetaData() {
        return this.relationPropertyType.getBeanMetaData();
    }

    public boolean hasNextRelationProperty() {
        return this.getRelationBeanMetaData().getRelationPropertyTypeSize() > 0;
    }

    public void backupRelationPropertyType() {
        this.getOrCreateRelationPropertyTypeBackup().push(this.getRelationPropertyType());
    }

    public void restoreRelationPropertyType() {
        this.setRelationPropertyType(this.getOrCreateRelationPropertyTypeBackup().pop());
    }

    protected Stack<TnRelationPropertyType> getOrCreateRelationPropertyTypeBackup() {
        if (this.relationPropertyTypeBackup == null) {
            this.relationPropertyTypeBackup = new Stack();
        }
        return this.relationPropertyTypeBackup;
    }

    public boolean containsColumnName(String columnName) {
        return this.columnNames.contains(columnName);
    }

    public boolean existsRelKeyValues() {
        return this.relKeyValues != null;
    }

    public boolean containsRelKeyValue(String key) {
        return this.relKeyValues.containsKey(key);
    }

    public boolean containsRelKeyValueIfExists(String key) {
        return this.existsRelKeyValues() && this.relKeyValues.containsKey(key);
    }

    public Object extractRelKeyValue(String key) {
        return this.relKeyValues.get(key);
    }

    public void initializePropertyCacheElement() {
        this.relationPropertyCache.put(this.relationNoSuffix, new HashMap());
    }

    public boolean hasPropertyCacheElement() {
        Map<String, TnPropertyType> propertyCacheElement = this.extractPropertyCacheElement();
        return propertyCacheElement != null && !propertyCacheElement.isEmpty();
    }

    public Map<String, TnPropertyType> extractPropertyCacheElement() {
        return this.relationPropertyCache.get(this.relationNoSuffix);
    }

    public void savePropertyCacheElement() {
        String columnName;
        Map<String, TnPropertyType> propertyCacheElement;
        if (!this.hasPropertyCacheElement()) {
            this.initializePropertyCacheElement();
        }
        if ((propertyCacheElement = this.extractPropertyCacheElement()).containsKey(columnName = this.buildRelationColumnName())) {
            return;
        }
        propertyCacheElement.put(columnName, this.currentPropertyType);
    }

    public String buildRelationColumnName() {
        return this.currentPropertyType.getColumnName() + this.relationNoSuffix;
    }

    public void addRelationNoSuffix(String additionalRelationNoSuffix) {
        this.relationNoSuffix = this.relationNoSuffix + additionalRelationNoSuffix;
    }

    public void backupSuffixAndPrepare(String baseSuffix, String additionalRelationNoSuffix) {
        this.backupBaseSuffix();
        this.backupRelationNoSuffix();
        this.baseSuffix = baseSuffix;
        this.addRelationNoSuffix(additionalRelationNoSuffix);
    }

    public void restoreSuffix() {
        this.restoreBaseSuffix();
        this.restoreRelationNoSuffix();
    }

    protected void backupBaseSuffix() {
        this.getOrCreateBaseSuffixBackup().push(this.getBaseSuffix());
    }

    protected void restoreBaseSuffix() {
        this.setBaseSuffix(this.getOrCreateBaseSuffixBackup().pop());
    }

    protected Stack<String> getOrCreateBaseSuffixBackup() {
        if (this.baseSuffixBackup == null) {
            this.baseSuffixBackup = new Stack();
        }
        return this.baseSuffixBackup;
    }

    protected void backupRelationNoSuffix() {
        this.getOrCreateRelationNoSuffixBackup().push(this.getRelationNoSuffix());
    }

    protected void restoreRelationNoSuffix() {
        this.setRelationNoSuffix(this.getOrCreateRelationNoSuffixBackup().pop());
    }

    protected Stack<String> getOrCreateRelationNoSuffixBackup() {
        if (this.relationSuffixBackup == null) {
            this.relationSuffixBackup = new Stack();
        }
        return this.relationSuffixBackup;
    }

    public boolean hasNextRelationLevel() {
        return this.currentRelationNestLevel < this.limitRelationNestLevel;
    }

    public void incrementCurrentRelationNestLevel() {
        ++this.currentRelationNestLevel;
    }

    public void decrementCurrentRelationNestLevel() {
        --this.currentRelationNestLevel;
    }

    public void incrementValidValueCount() {
        ++this.validValueCount;
    }

    public void clearValidValueCount() {
        this.validValueCount = 0;
    }

    public boolean hasValidValueCount() {
        return this.validValueCount > 0;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Set<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(Set<String> columnNames) {
        this.columnNames = columnNames;
    }

    public Map<String, Object> getRelKeyValues() {
        return this.relKeyValues;
    }

    public void setRelKeyValues(Map<String, Object> relKeyValues) {
        this.relKeyValues = relKeyValues;
    }

    public Object getRow() {
        return this.row;
    }

    public void setRow(Object row) {
        this.row = row;
    }

    public TnRelationPropertyType getRelationPropertyType() {
        return this.relationPropertyType;
    }

    public void setRelationPropertyType(TnRelationPropertyType rpt) {
        this.relationPropertyType = rpt;
    }

    public Map<String, Map<String, TnPropertyType>> getRelationPropertyCache() {
        return this.relationPropertyCache;
    }

    public void setRelationPropertyCache(Map<String, Map<String, TnPropertyType>> relationPropertyCache) {
        this.relationPropertyCache = relationPropertyCache;
    }

    public String getBaseSuffix() {
        return this.baseSuffix;
    }

    public void setBaseSuffix(String baseSuffix) {
        this.baseSuffix = baseSuffix;
    }

    public String getRelationNoSuffix() {
        return this.relationNoSuffix;
    }

    public void setRelationNoSuffix(String relationNoSuffix) {
        this.relationNoSuffix = relationNoSuffix;
    }

    public int getLimitRelationNestLevel() {
        return this.limitRelationNestLevel;
    }

    public void setLimitRelationNestLevel(int limitRelationNestLevel) {
        this.limitRelationNestLevel = limitRelationNestLevel;
    }

    public int getCurrentRelationNestLevel() {
        return this.currentRelationNestLevel;
    }

    public void setCurrentRelationNestLevel(int currentRelationNestLevel) {
        this.currentRelationNestLevel = currentRelationNestLevel;
    }

    public TnPropertyType getCurrentPropertyType() {
        return this.currentPropertyType;
    }

    public void setCurrentPropertyType(TnPropertyType propertyType) {
        this.currentPropertyType = propertyType;
    }

    public boolean isCreateDeadLink() {
        return this.createDeadLink;
    }

    public void setCreateDeadLink(boolean createDeadLink) {
        this.createDeadLink = createDeadLink;
    }

    public Map<String, Integer> getSelectIndexMap() {
        return this._selectIndexMap;
    }

    public void setSelectIndexMap(Map<String, Integer> selectIndexMap) {
        this._selectIndexMap = selectIndexMap;
    }
}

