/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.processor.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.robot.S2RobotContext;
import org.seasar.robot.entity.AccessResult;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.entity.ResultData;
import org.seasar.robot.entity.UrlQueue;
import org.seasar.robot.processor.ResponseProcessor;
import org.seasar.robot.service.UrlQueueService;
import org.seasar.robot.transformer.Transformer;
import org.seasar.robot.util.CrawlingParameterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseProcessor
implements ResponseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResponseProcessor.class);
    protected Transformer transformer;

    @Override
    public void process(ResponseData responseData) {
        if (responseData.getStatus() == 304) {
            UrlQueue urlQueue = CrawlingParameterUtil.getUrlQueue();
            ResultData resultData = new ResultData();
            Set<String> emptySet = Collections.emptySet();
            resultData.setChildUrlSet(emptySet);
            resultData.setData(new byte[0]);
            resultData.setEncoding("UTF-8");
            resultData.setTransformerName("NONE");
            this.processResult(urlQueue, responseData, resultData);
        } else if (this.transformer != null) {
            ResultData resultData = this.transformer.transform(responseData);
            if (resultData != null) {
                UrlQueue urlQueue = CrawlingParameterUtil.getUrlQueue();
                this.processResult(urlQueue, responseData, resultData);
            } else {
                logger.warn("No data for (" + responseData.getUrl() + ", " + responseData.getMimeType() + ")");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("No Transformer for (" + responseData.getUrl() + "). PLEASE CHECK YOUR CONFIGURATION.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResult(UrlQueue urlQueue, ResponseData responseData, ResultData resultData) {
        AccessResult accessResult = (AccessResult)SingletonS2Container.getComponent(AccessResult.class);
        accessResult.init(responseData, resultData);
        S2RobotContext robotContext = CrawlingParameterUtil.getRobotContext();
        UrlQueueService urlQueueService = CrawlingParameterUtil.getUrlQueueService();
        Object object = robotContext.getAccessCountLock();
        synchronized (object) {
            if (!urlQueueService.visited(urlQueue)) {
                if (this.checkAccessCount(robotContext)) {
                    CrawlingParameterUtil.getDataService().store(accessResult);
                    this.storeChildUrls(robotContext, resultData.getChildUrlSet(), urlQueue.getUrl(), urlQueue.getDepth() != null ? urlQueue.getDepth() + 1 : 1);
                    if (robotContext.getMaxAccessCount() > 0L) {
                        robotContext.setAccessCount(robotContext.getAccessCount() + 1L);
                    }
                } else {
                    ArrayList<UrlQueue> newUrlQueueList = new ArrayList<UrlQueue>();
                    newUrlQueueList.add(urlQueue);
                    urlQueueService.offerAll(robotContext.getSessionId(), newUrlQueueList);
                }
            }
        }
    }

    private boolean checkAccessCount(S2RobotContext robotContext) {
        if (robotContext.getMaxAccessCount() > 0L) {
            return robotContext.getAccessCount() < robotContext.getMaxAccessCount();
        }
        return true;
    }

    private void storeChildUrls(S2RobotContext robotContext, Set<String> childUrlList, String url, int depth) {
        ArrayList<UrlQueue> childList = new ArrayList<UrlQueue>();
        for (String childUrl : childUrlList) {
            if (!robotContext.getUrlFilter().match(childUrl)) continue;
            UrlQueue uq = (UrlQueue)SingletonS2Container.getComponent(UrlQueue.class);
            uq.setCreateTime(new Timestamp(new Date().getTime()));
            uq.setDepth(depth);
            uq.setMethod("GET");
            uq.setParentUrl(url);
            uq.setSessionId(robotContext.getSessionId());
            uq.setUrl(childUrl);
            childList.add(uq);
        }
        CrawlingParameterUtil.getUrlQueueService().offerAll(robotContext.getSessionId(), childList);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }
}

