/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaConfig {
    private final Map<String, Parser> parsers = new HashMap<String, Parser>();
    private final MimeTypes mimeTypes;

    public TikaConfig(String file) throws TikaException, IOException, SAXException {
        this(new File(file));
    }

    public TikaConfig(File file) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(file));
    }

    public TikaConfig(URL url) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(url.toString()));
    }

    public TikaConfig(InputStream stream) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(stream));
    }

    public TikaConfig(InputStream stream, Parser delegate) throws TikaException, IOException, SAXException {
        this(stream);
    }

    public TikaConfig(Document document) throws TikaException, IOException {
        this(document.getDocumentElement());
    }

    public TikaConfig(Document document, Parser delegate) throws TikaException, IOException {
        this(document);
    }

    public TikaConfig(Element element) throws TikaException, IOException {
        Element mtr = TikaConfig.getChild(element, "mimeTypeRepository");
        this.mimeTypes = mtr != null && mtr.hasAttribute("resource") ? MimeTypesFactory.create(mtr.getAttribute("resource")) : MimeTypesFactory.create("tika-mimetypes.xml");
        NodeList nodes = element.getElementsByTagName("parser");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element node = (Element)nodes.item(i);
            String name = node.getAttribute("class");
            try {
                Class<?> parserClass = Class.forName(name);
                Object instance = parserClass.newInstance();
                if (!(instance instanceof Parser)) {
                    throw new TikaException("Configured class is not a Tika Parser: " + name);
                }
                Parser parser = (Parser)instance;
                NodeList mimes = node.getElementsByTagName("mime");
                if (mimes.getLength() > 0) {
                    for (int j = 0; j < mimes.getLength(); ++j) {
                        this.parsers.put(this.getText(mimes.item(j)).trim(), parser);
                    }
                    continue;
                }
                ParseContext context = new ParseContext();
                for (MediaType type : parser.getSupportedTypes(context)) {
                    this.parsers.put(type.toString(), parser);
                }
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new TikaException("Configured parser class not found: " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new TikaException("Unable to access a parser class: " + name, e);
            }
            catch (InstantiationException e) {
                throw new TikaException("Unable to instantiate a parser class: " + name, e);
            }
        }
    }

    public TikaConfig() throws MimeTypeException, IOException {
        ParseContext context = new ParseContext();
        Iterator<Parser> iterator = ServiceRegistry.lookupProviders(Parser.class);
        while (iterator.hasNext()) {
            Parser parser = iterator.next();
            for (MediaType type : parser.getSupportedTypes(context)) {
                this.parsers.put(type.toString(), parser);
            }
        }
        this.mimeTypes = MimeTypesFactory.create("tika-mimetypes.xml");
    }

    public TikaConfig(Element element, Parser delegate) throws TikaException, IOException {
        this(element);
    }

    private String getText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            StringBuilder builder = new StringBuilder();
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                builder.append(this.getText(list.item(i)));
            }
            return builder.toString();
        }
        return "";
    }

    public Parser getParser(String mimeType) {
        return this.parsers.get(mimeType);
    }

    public Map<String, Parser> getParsers() {
        return this.parsers;
    }

    public MimeTypes getMimeRepository() {
        return this.mimeTypes;
    }

    public static TikaConfig getDefaultConfig() {
        try {
            return new TikaConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read default configuration", e);
        }
        catch (TikaException e) {
            throw new RuntimeException("Unable to access default configuration", e);
        }
    }

    public static TikaConfig getDefaultConfig(Parser delegate) throws TikaException {
        return TikaConfig.getDefaultConfig();
    }

    private static DocumentBuilder getBuilder() throws TikaException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser not available", e);
        }
    }

    private static Element getChild(Element element, String name) {
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }
}

