/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.apache.solr.handler.dataimport.EvaluatorBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListEntityProcessor
extends EntityProcessorBase {
    protected String fileName;
    protected String baseDir;
    protected String excludes;
    protected Date newerThan;
    protected Date olderThan;
    protected long biggerThan = -1L;
    protected long smallerThan = -1L;
    protected boolean recursive = false;
    private Pattern fileNamePattern;
    private Pattern excludesPattern;
    public static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    public static final String DIR = "fileDir";
    public static final String FILE = "file";
    public static final String ABSOLUTE_FILE = "fileAbsolutePath";
    public static final String SIZE = "fileSize";
    public static final String LAST_MODIFIED = "fileLastModified";
    public static final String FILE_NAME = "fileName";
    public static final String BASE_DIR = "baseDir";
    public static final String EXCLUDES = "excludes";
    public static final String NEWER_THAN = "newerThan";
    public static final String OLDER_THAN = "olderThan";
    public static final String BIGGER_THAN = "biggerThan";
    public static final String SMALLER_THAN = "smallerThan";
    public static final String RECURSIVE = "recursive";

    @Override
    public void init(Context context) {
        super.init(context);
        this.fileName = context.getEntityAttribute(FILE_NAME);
        if (this.fileName != null) {
            this.fileName = this.resolver.replaceTokens(this.fileName);
            this.fileNamePattern = Pattern.compile(this.fileName);
        }
        this.baseDir = context.getEntityAttribute(BASE_DIR);
        if (this.baseDir == null) {
            throw new DataImportHandlerException(500, "'baseDir' is a required attribute");
        }
        this.baseDir = this.resolver.replaceTokens(this.baseDir);
        File dir = new File(this.baseDir);
        if (!dir.isDirectory()) {
            throw new DataImportHandlerException(500, "'baseDir' value: " + this.baseDir + " is not a directory");
        }
        String r = context.getEntityAttribute(RECURSIVE);
        if (r != null) {
            this.recursive = Boolean.parseBoolean(r);
        }
        this.excludes = context.getEntityAttribute(EXCLUDES);
        if (this.excludes != null) {
            this.excludes = this.resolver.replaceTokens(this.excludes);
            this.excludesPattern = Pattern.compile(this.excludes);
        }
    }

    private Date getDate(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        Matcher m = PLACE_HOLDER_PATTERN.matcher(dateStr);
        if (m.find()) {
            Object o = this.resolver.resolve(m.group(1));
            if (o instanceof Date) {
                return (Date)o;
            }
            dateStr = (String)o;
        } else {
            dateStr = this.resolver.replaceTokens(dateStr);
        }
        m = EvaluatorBag.IN_SINGLE_QUOTES.matcher(dateStr);
        if (m.find()) {
            String expr = null;
            expr = m.group(1).replaceAll("NOW", "");
            try {
                return EvaluatorBag.dateMathParser.parseMath(expr);
            }
            catch (ParseException exp) {
                throw new DataImportHandlerException(500, "Invalid expression for date", exp);
            }
        }
        try {
            return DataImporter.DATE_TIME_FORMAT.get().parse(dateStr);
        }
        catch (ParseException exp) {
            throw new DataImportHandlerException(500, "Invalid expression for date", exp);
        }
    }

    private Long getSize(String sizeStr) {
        if (sizeStr == null) {
            return null;
        }
        Matcher m = PLACE_HOLDER_PATTERN.matcher(sizeStr);
        if (m.find()) {
            Object o = this.resolver.resolve(m.group(1));
            if (o instanceof Number) {
                Number number = (Number)o;
                return number.longValue();
            }
            sizeStr = (String)o;
        } else {
            sizeStr = this.resolver.replaceTokens(sizeStr);
        }
        return Long.parseLong(sizeStr);
    }

    @Override
    public Map<String, Object> nextRow() {
        String smallerThanStr;
        if (this.rowIterator != null) {
            return this.getNext();
        }
        ArrayList<Map<String, Object>> fileDetails = new ArrayList<Map<String, Object>>();
        File dir = new File(this.baseDir);
        String dateStr = this.context.getEntityAttribute(NEWER_THAN);
        this.newerThan = this.getDate(dateStr);
        dateStr = this.context.getEntityAttribute(OLDER_THAN);
        this.olderThan = this.getDate(dateStr);
        String biggerThanStr = this.context.getEntityAttribute(BIGGER_THAN);
        if (biggerThanStr != null) {
            this.biggerThan = this.getSize(biggerThanStr);
        }
        if ((smallerThanStr = this.context.getEntityAttribute(SMALLER_THAN)) != null) {
            this.smallerThan = this.getSize(smallerThanStr);
        }
        this.getFolderFiles(dir, fileDetails);
        this.rowIterator = fileDetails.iterator();
        return this.getNext();
    }

    private void getFolderFiles(File dir, final List<Map<String, Object>> fileDetails) {
        dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File fileObj = new File(dir, name);
                if (fileObj.isDirectory()) {
                    if (FileListEntityProcessor.this.recursive) {
                        FileListEntityProcessor.this.getFolderFiles(fileObj, fileDetails);
                    }
                } else if (FileListEntityProcessor.this.fileNamePattern == null) {
                    FileListEntityProcessor.this.addDetails(fileDetails, dir, name);
                } else if (FileListEntityProcessor.this.fileNamePattern.matcher(name).find()) {
                    if (FileListEntityProcessor.this.excludesPattern != null && FileListEntityProcessor.this.excludesPattern.matcher(name).find()) {
                        return false;
                    }
                    FileListEntityProcessor.this.addDetails(fileDetails, dir, name);
                }
                return false;
            }
        });
    }

    private void addDetails(List<Map<String, Object>> files, File dir, String name) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        File aFile = new File(dir, name);
        if (aFile.isDirectory()) {
            return;
        }
        long sz = aFile.length();
        Date lastModified = new Date(aFile.lastModified());
        if (this.biggerThan != -1L && sz <= this.biggerThan) {
            return;
        }
        if (this.smallerThan != -1L && sz >= this.smallerThan) {
            return;
        }
        if (this.olderThan != null && lastModified.after(this.olderThan)) {
            return;
        }
        if (this.newerThan != null && lastModified.before(this.newerThan)) {
            return;
        }
        details.put(DIR, dir.getAbsolutePath());
        details.put(FILE, name);
        details.put(ABSOLUTE_FILE, aFile.getAbsolutePath());
        details.put(SIZE, sz);
        details.put(LAST_MODIFIED, lastModified);
        files.add(details);
    }
}

