/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.EvaluatorBag;
import org.apache.solr.handler.dataimport.EventListener;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.SqlEntityProcessor;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.apache.solr.schema.SchemaField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DocBuilder.class);
    private static final Date EPOCH = new Date(0L);
    DataImporter dataImporter;
    private DataConfig.Document document;
    private DataConfig.Entity root;
    private Map statusMessages = Collections.synchronizedMap(new LinkedHashMap());
    public Statistics importStatistics = new Statistics();
    SolrWriter writer;
    DataImporter.RequestParams requestParameters;
    boolean verboseDebug = false;
    private Map<String, Object> session = new HashMap<String, Object>();
    static final ThreadLocal<DocBuilder> INSTANCE = new ThreadLocal();
    Map<String, Object> functionsNamespace;
    private Properties persistedProperties;
    private AtomicBoolean stop = new AtomicBoolean(false);
    public static final String TIME_ELAPSED = "Time Elapsed";
    public static final String LAST_INDEX_TIME = "last_index_time";
    public static final String INDEX_START_TIME = "index_start_time";

    public DocBuilder(DataImporter dataImporter, SolrWriter writer, DataImporter.RequestParams reqParams) {
        INSTANCE.set(this);
        this.dataImporter = dataImporter;
        this.writer = writer;
        DataImporter.QUERY_COUNT.set(this.importStatistics.queryCount);
        this.requestParameters = reqParams;
        this.verboseDebug = this.requestParameters.debug && this.requestParameters.verbose;
        this.functionsNamespace = EvaluatorBag.getFunctionsNamespace(this.dataImporter.getConfig().functions, this);
        this.persistedProperties = writer.readIndexerProperties();
    }

    public VariableResolverImpl getVariableResolver() {
        try {
            VariableResolverImpl resolver = new VariableResolverImpl();
            HashMap<String, Object> indexerNamespace = new HashMap<String, Object>();
            if (this.persistedProperties.getProperty(LAST_INDEX_TIME) != null) {
                indexerNamespace.put(LAST_INDEX_TIME, this.persistedProperties.getProperty(LAST_INDEX_TIME));
            } else {
                indexerNamespace.put(LAST_INDEX_TIME, DataImporter.DATE_TIME_FORMAT.get().format(EPOCH));
            }
            indexerNamespace.put(INDEX_START_TIME, this.dataImporter.getIndexStartTime());
            indexerNamespace.put("request", this.requestParameters.requestParams);
            indexerNamespace.put("functions", this.functionsNamespace);
            for (DataConfig.Entity entity : this.dataImporter.getConfig().document.entities) {
                String key = entity.name + "." + LAST_INDEX_TIME;
                String lastIndex = this.persistedProperties.getProperty(key);
                if (lastIndex != null) {
                    indexerNamespace.put(key, lastIndex);
                    continue;
                }
                indexerNamespace.put(key, DataImporter.DATE_TIME_FORMAT.get().format(EPOCH));
            }
            resolver.addNamespace("dih", indexerNamespace);
            resolver.addNamespace("dataimporter", indexerNamespace);
            return resolver;
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e);
            return null;
        }
    }

    private void invokeEventListener(String className) {
        try {
            EventListener listener = (EventListener)DocBuilder.loadClass(className, this.dataImporter.getCore()).newInstance();
            this.notifyListener(listener);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to load class : " + className);
        }
    }

    private void notifyListener(EventListener listener) {
        String currentProcess = this.dataImporter.getStatus() == DataImporter.Status.RUNNING_DELTA_DUMP ? "DELTA_DUMP" : "FULL_DUMP";
        listener.onEvent(new ContextImpl(null, this.getVariableResolver(), null, currentProcess, this.session, null, this));
    }

    public void execute() {
        this.dataImporter.store("status-messages", this.statusMessages);
        this.document = this.dataImporter.getConfig().document;
        final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());
        this.statusMessages.put(TIME_ELAPSED, new Object(){

            public String toString() {
                return DocBuilder.getTimeElapsedSince(startTime.get());
            }
        });
        this.statusMessages.put("Total Requests made to DataSource", this.importStatistics.queryCount);
        this.statusMessages.put("Total Rows Fetched", this.importStatistics.rowsCount);
        this.statusMessages.put("Total Documents Processed", this.importStatistics.docCount);
        this.statusMessages.put("Total Documents Skipped", this.importStatistics.skipDocCount);
        List<String> entities = this.requestParameters.entities;
        if (this.document.onImportStart != null) {
            this.invokeEventListener(this.document.onImportStart);
        }
        AtomicBoolean fullCleanDone = new AtomicBoolean(false);
        Properties lastIndexTimeProps = new Properties();
        lastIndexTimeProps.setProperty(LAST_INDEX_TIME, DataImporter.DATE_TIME_FORMAT.get().format(this.dataImporter.getIndexStartTime()));
        for (DataConfig.Entity e : this.document.entities) {
            if (entities != null && !entities.contains(e.name)) continue;
            lastIndexTimeProps.setProperty(e.name + "." + LAST_INDEX_TIME, DataImporter.DATE_TIME_FORMAT.get().format(new Date()));
            this.root = e;
            String delQuery = e.allAttributes.get("preImportDeleteQuery");
            if (this.dataImporter.getStatus() == DataImporter.Status.RUNNING_DELTA_DUMP) {
                this.cleanByQuery(delQuery, fullCleanDone);
                this.doDelta();
                delQuery = e.allAttributes.get("postImportDeleteQuery");
                if (delQuery != null) {
                    fullCleanDone.set(false);
                    this.cleanByQuery(delQuery, fullCleanDone);
                }
            } else {
                this.cleanByQuery(delQuery, fullCleanDone);
                this.doFullDump();
                delQuery = e.allAttributes.get("postImportDeleteQuery");
                if (delQuery != null) {
                    fullCleanDone.set(false);
                    this.cleanByQuery(delQuery, fullCleanDone);
                }
            }
            this.statusMessages.remove("Total Documents Processed");
        }
        if (this.stop.get()) {
            this.statusMessages.put("Aborted", DataImporter.DATE_TIME_FORMAT.get().format(new Date()));
            this.rollback();
        } else {
            if (!this.requestParameters.clean) {
                if (this.importStatistics.docCount.get() > 0L || this.importStatistics.deletedDocCount.get() > 0L) {
                    this.finish(lastIndexTimeProps);
                }
            } else {
                this.finish(lastIndexTimeProps);
            }
            if (this.document.onImportEnd != null) {
                this.invokeEventListener(this.document.onImportEnd);
            }
        }
        this.statusMessages.remove(TIME_ELAPSED);
        this.statusMessages.put("Total Documents Processed", "" + this.importStatistics.docCount.get());
        if (this.importStatistics.failedDocCount.get() > 0L) {
            this.statusMessages.put("Total Documents Failed", "" + this.importStatistics.failedDocCount.get());
        }
        this.statusMessages.put("Time taken ", DocBuilder.getTimeElapsedSince(startTime.get()));
        LOG.info("Time taken = " + DocBuilder.getTimeElapsedSince(startTime.get()));
    }

    private void finish(Properties lastIndexTimeProps) {
        LOG.info("Import completed successfully");
        this.statusMessages.put("", "Indexing completed. Added/Updated: " + this.importStatistics.docCount + " documents. Deleted " + this.importStatistics.deletedDocCount + " documents.");
        if (this.requestParameters.commit) {
            this.writer.commit(this.requestParameters.optimize);
            this.addStatusMessage("Committed");
            if (this.requestParameters.optimize) {
                this.addStatusMessage("Optimized");
            }
        }
        this.writer.persist(lastIndexTimeProps);
    }

    void rollback() {
        this.writer.rollback();
        this.statusMessages.put("", "Indexing failed. Rolled back all changes.");
        this.addStatusMessage("Rolledback");
    }

    private void doFullDump() {
        this.addStatusMessage("Full Dump Started");
        this.buildDocument(this.getVariableResolver(), null, null, this.root, true, null);
    }

    private void doDelta() {
        this.addStatusMessage("Delta Dump started");
        VariableResolverImpl resolver = this.getVariableResolver();
        if (this.document.deleteQuery != null) {
            this.writer.deleteByQuery(this.document.deleteQuery);
        }
        this.addStatusMessage("Identifying Delta");
        LOG.info("Starting delta collection.");
        HashSet<Map<String, Object>> deletedKeys = new HashSet<Map<String, Object>>();
        Set<Map<String, Object>> allPks = this.collectDelta(this.root, resolver, deletedKeys);
        if (this.stop.get()) {
            return;
        }
        this.addStatusMessage("Deltas Obtained");
        this.addStatusMessage("Building documents");
        if (!deletedKeys.isEmpty()) {
            allPks.removeAll(deletedKeys);
            this.deleteAll(deletedKeys);
        }
        deletedKeys = null;
        this.statusMessages.put("Total Changed Documents", allPks.size());
        VariableResolverImpl vri = this.getVariableResolver();
        Iterator<Map<String, Object>> pkIter = allPks.iterator();
        while (pkIter.hasNext()) {
            Map<String, Object> map = pkIter.next();
            vri.addNamespace("dih.delta", map);
            this.buildDocument(vri, null, map, this.root, true, null);
            pkIter.remove();
            if (!this.stop.get()) continue;
            break;
        }
        if (!this.stop.get()) {
            LOG.info("Delta Import completed successfully");
        }
    }

    private void deleteAll(Set<Map<String, Object>> deletedKeys) {
        LOG.info("Deleting stale documents ");
        Iterator<Map<String, Object>> iter = deletedKeys.iterator();
        while (iter.hasNext()) {
            Map<String, Object> map = iter.next();
            Object key = map.get(this.root.getPk());
            if (key == null) {
                LOG.warn("no key was available for deleteted pk query");
                continue;
            }
            this.writer.deleteDoc(key);
            this.importStatistics.deletedDocCount.incrementAndGet();
            iter.remove();
        }
    }

    public void addStatusMessage(String msg) {
        this.statusMessages.put(msg, DataImporter.DATE_TIME_FORMAT.get().format(new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void buildDocument(VariableResolverImpl vr, DocWrapper doc, Map<String, Object> pk, DataConfig.Entity entity, boolean isRoot, ContextImpl parentCtx) {
        block40: {
            entityProcessor = this.getEntityProcessor(entity);
            ctx = new ContextImpl(entity, vr, null, pk == null ? "FULL_DUMP" : "DELTA_DUMP", this.session, parentCtx, this);
            entityProcessor.init(ctx);
            if (this.requestParameters.start > 0) {
                this.writer.log(12, null, null);
            }
            if (this.verboseDebug) {
                this.writer.log(1, entity.name, null);
            }
            seenDocCount = 0;
            while (true) lbl-1000:
            // 9 sources

            {
                if (this.stop.get()) {
                    return;
                }
                if (this.importStatistics.docCount.get() > (long)this.requestParameters.start + this.requestParameters.rows) {
                    break block40;
                }
                try {
                    if (++seenDocCount > this.requestParameters.start) {
                        this.writer.log(13, null, null);
                    }
                    if (this.verboseDebug && entity.isDocRoot) {
                        this.writer.log(6, entity.name, null);
                    }
                    if (doc == null && entity.isDocRoot) {
                        doc = new DocWrapper();
                        ctx.setDoc(doc);
                        e = entity;
                        while (e.parentEntity != null) {
                            this.addFields(e.parentEntity, doc, (Map)vr.resolve(e.parentEntity.name), vr);
                            e = e.parentEntity;
                        }
                    }
                    if ((arow = entityProcessor.nextRow()) == null) break block40;
                    if (entity.isDocRoot) {
                        if (seenDocCount <= this.requestParameters.start) ** GOTO lbl-1000
                        if ((long)seenDocCount > (long)this.requestParameters.start + this.requestParameters.rows) {
                            DocBuilder.LOG.info("Indexing stopped at docCount = " + this.importStatistics.docCount);
                            break block40;
                        }
                    }
                    if (this.verboseDebug) {
                        this.writer.log(8, entity.name, arow);
                    }
                    this.importStatistics.rowsCount.incrementAndGet();
                    if (doc != null) {
                        this.handleSpecialCommands(arow, doc);
                        this.addFields(entity, doc, arow, vr);
                    }
                    if (entity.entities != null) {
                        vr.addNamespace(entity.name, arow);
                        for (DataConfig.Entity child : entity.entities) {
                            this.buildDocument(vr, doc, null, child, false, ctx);
                        }
                        vr.removeNamespace(entity.name);
                    }
                    if (!entity.isDocRoot) ** GOTO lbl-1000
                    if (this.stop.get()) {
                        return;
                    }
                    if (doc.isEmpty()) ** GOTO lbl-1000
                    result = this.writer.upload(doc);
                    doc = null;
                    if (result) {
                        this.importStatistics.docCount.incrementAndGet();
                    }
                    this.importStatistics.failedDocCount.incrementAndGet();
                }
                catch (DataImportHandlerException e) {
                    if (this.verboseDebug) {
                        this.writer.log(11, entity.name, e);
                    }
                    if (e.getErrCode() == 301) ** GOTO lbl-1000
                    if (isRoot) {
                        if (e.getErrCode() == 300) {
                            this.importStatistics.skipDocCount.getAndIncrement();
                        } else {
                            DocBuilder.LOG.error("Exception while processing: " + entity.name + " document : " + (Object)doc, (Throwable)e);
                        }
                        if (e.getErrCode() != 500) ** GOTO lbl-1000
                        throw e;
                    }
                    throw e;
                }
                catch (Throwable t) {
                    if (this.verboseDebug) {
                        this.writer.log(11, entity.name, t);
                    }
                    throw new DataImportHandlerException(500, t);
                }
                finally {
                    if (!this.verboseDebug) continue;
                    this.writer.log(9, entity.name, null);
                    if (!entity.isDocRoot) continue;
                    this.writer.log(7, null, null);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.verboseDebug) {
                    this.writer.log(2, null, null);
                }
                entityProcessor.destroy();
            }
        }
    }

    private void handleSpecialCommands(Map<String, Object> arow, DocWrapper doc) {
        Collection collection;
        Object value = arow.get("$deleteDocById");
        if (value != null) {
            if (value instanceof Collection) {
                collection = (Collection)value;
                for (Object o : collection) {
                    this.writer.deleteDoc(o.toString());
                }
            } else {
                this.writer.deleteDoc(value);
            }
        }
        if ((value = arow.get("$deleteDocByQuery")) != null) {
            if (value instanceof Collection) {
                collection = (Collection)value;
                for (Object o : collection) {
                    this.writer.deleteByQuery(o.toString());
                }
            } else {
                this.writer.deleteByQuery(value.toString());
            }
        }
        if ((value = arow.get("$docBoost")) != null) {
            float value1 = 1.0f;
            value1 = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
            doc.setDocumentBoost(value1);
        }
        if ((value = arow.get("$skipDoc")) != null && Boolean.parseBoolean(value.toString())) {
            throw new DataImportHandlerException(300, "Document skipped :" + arow);
        }
        value = arow.get("$skipRow");
        if (value != null && Boolean.parseBoolean(value.toString())) {
            throw new DataImportHandlerException(301);
        }
    }

    private void addFields(DataConfig.Entity entity, DocWrapper doc, Map<String, Object> arow, VariableResolver vr) {
        for (Map.Entry<String, Object> entry : arow.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || key.startsWith("$")) continue;
            List<DataConfig.Field> field = entity.colNameVsField.get(key);
            if (field == null && this.dataImporter.getSchema() != null) {
                SchemaField sf = this.dataImporter.getSchema().getFieldOrNull(key);
                if (sf == null) {
                    sf = this.dataImporter.getConfig().lowerNameVsSchemaField.get(key.toLowerCase());
                }
                if (sf == null) continue;
                this.addFieldToDoc(entry.getValue(), sf.getName(), 1.0f, sf.multiValued(), doc);
                continue;
            }
            if (field == null) continue;
            for (DataConfig.Field f : field) {
                String name = f.getName();
                if (f.dynamicName) {
                    name = vr.replaceTokens(name);
                }
                if (!f.toWrite) continue;
                this.addFieldToDoc(entry.getValue(), name, f.boost.floatValue(), f.multiValued, doc);
            }
        }
    }

    private void addFieldToDoc(Object value, String name, float boost, boolean multiValued, DocWrapper doc) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (multiValued) {
                for (Object o : collection) {
                    if (o == null) continue;
                    doc.addField(name, o, boost);
                }
            } else if (doc.getField(name) == null) {
                for (Object o : collection) {
                    if (o == null) continue;
                    doc.addField(name, o, boost);
                    break;
                }
            }
        } else if (multiValued) {
            if (value != null) {
                doc.addField(name, value, boost);
            }
        } else if (doc.getField(name) == null && value != null) {
            doc.addField(name, value, boost);
        }
    }

    private EntityProcessorWrapper getEntityProcessor(DataConfig.Entity entity) {
        EntityProcessor entityProcessor;
        if (entity.processor != null) {
            return entity.processor;
        }
        if (entity.proc == null) {
            entityProcessor = new SqlEntityProcessor();
        } else {
            try {
                entityProcessor = (EntityProcessor)DocBuilder.loadClass(entity.proc, this.dataImporter.getCore()).newInstance();
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Unable to load EntityProcessor implementation for entity:" + entity.name, e);
            }
        }
        entity.processor = new EntityProcessorWrapper(entityProcessor, this);
        return entity.processor;
    }

    public Set<Map<String, Object>> collectDelta(DataConfig.Entity entity, VariableResolverImpl resolver, Set<Map<String, Object>> deletedRows) {
        Map<String, Object> row;
        Map<String, Object> row2;
        if (this.stop.get()) {
            return new HashSet<Map<String, Object>>();
        }
        EntityProcessorWrapper entityProcessor = this.getEntityProcessor(entity);
        ContextImpl context1 = new ContextImpl(entity, resolver, null, "FIND_DELTA", this.session, null, this);
        ((EntityProcessor)entityProcessor).init(context1);
        HashSet<Map<String, Object>> myModifiedPks = new HashSet<Map<String, Object>>();
        if (entity.entities != null) {
            for (DataConfig.Entity entity1 : entity.entities) {
                myModifiedPks.addAll(this.collectDelta(entity1, resolver, deletedRows));
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
        }
        HashSet<Map<String, Object>> deltaSet = new HashSet<Map<String, Object>>();
        LOG.info("Running ModifiedRowKey() for Entity: " + entity.name);
        while ((row2 = ((EntityProcessor)entityProcessor).nextModifiedRowKey()) != null) {
            deltaSet.add(row2);
            this.importStatistics.rowsCount.incrementAndGet();
            if (!this.stop.get()) continue;
            return new HashSet<Map<String, Object>>();
        }
        HashSet<Map<String, Object>> deletedSet = new HashSet<Map<String, Object>>();
        HashSet<Map> deltaRemoveSet = new HashSet<Map>();
        while ((row = ((EntityProcessor)entityProcessor).nextDeletedRowKey()) != null) {
            for (Map map : deltaSet) {
                if (!map.get(entity.getPk()).equals(row.get(entity.getPk()))) continue;
                deltaRemoveSet.add(map);
            }
            deletedSet.add(row);
            this.importStatistics.rowsCount.incrementAndGet();
            if (!this.stop.get()) continue;
            return new HashSet<Map<String, Object>>();
        }
        deltaSet.removeAll(deltaRemoveSet);
        LOG.info("Completed ModifiedRowKey for Entity: " + entity.name + " rows obtained : " + deltaSet.size());
        LOG.info("Completed DeletedRowKey for Entity: " + entity.name + " rows obtained : " + deletedSet.size());
        myModifiedPks.addAll(deltaSet);
        HashSet<Map<String, Object>> parentKeyList = new HashSet<Map<String, Object>>();
        if (entity.parentEntity != null) {
            for (Map map : myModifiedPks) {
                this.getModifiedParentRows(resolver.addNamespace(entity.name, map), entity.name, entityProcessor, parentKeyList);
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
            for (Map map : deletedSet) {
                this.getModifiedParentRows(resolver.addNamespace(entity.name, map), entity.name, entityProcessor, parentKeyList);
                if (!this.stop.get()) continue;
                return new HashSet<Map<String, Object>>();
            }
        }
        LOG.info("Completed parentDeltaQuery for Entity: " + entity.name);
        if (entity.isDocRoot) {
            deletedRows.addAll(deletedSet);
        }
        return entity.isDocRoot ? myModifiedPks : new HashSet<Map<String, Object>>(parentKeyList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getModifiedParentRows(VariableResolverImpl resolver, String entity, EntityProcessor entityProcessor, Set<Map<String, Object>> parentKeyList) {
        try {
            Map<String, Object> parentRow;
            while ((parentRow = entityProcessor.nextModifiedParentRowKey()) != null) {
                parentKeyList.add(parentRow);
                this.importStatistics.rowsCount.incrementAndGet();
                if (!this.stop.get()) continue;
                return;
            }
        }
        finally {
            resolver.removeNamespace(entity);
        }
    }

    public void abort() {
        this.stop.set(true);
    }

    static String getTimeElapsedSince(long l) {
        l = System.currentTimeMillis() - l;
        return l / 3600000L % 60L + ":" + l / 60000L % 60L + ":" + l / 1000L % 60L + "." + l % 1000L;
    }

    static Class loadClass(String name, SolrCore core) throws ClassNotFoundException {
        try {
            return core != null ? core.getResourceLoader().findClass(name, new String[0]) : Class.forName(name);
        }
        catch (Exception e) {
            try {
                String n = DocBuilder.class.getPackage().getName() + "." + name;
                return core != null ? core.getResourceLoader().findClass(n, new String[0]) : Class.forName(n);
            }
            catch (Exception e1) {
                throw new ClassNotFoundException("Unable to load " + name + " or " + DocBuilder.class.getPackage().getName() + "." + name, e);
            }
        }
    }

    private void cleanByQuery(String delQuery, AtomicBoolean completeCleanDone) {
        delQuery = this.getVariableResolver().replaceTokens(delQuery);
        if (this.requestParameters.clean) {
            if (delQuery == null && !completeCleanDone.get()) {
                this.writer.doDeleteAll();
                completeCleanDone.set(true);
            } else if (delQuery != null) {
                this.writer.deleteByQuery(delQuery);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Statistics {
        public AtomicLong docCount = new AtomicLong();
        public AtomicLong deletedDocCount = new AtomicLong();
        public AtomicLong failedDocCount = new AtomicLong();
        public AtomicLong rowsCount = new AtomicLong();
        public AtomicLong queryCount = new AtomicLong();
        public AtomicLong skipDocCount = new AtomicLong();

        public Statistics add(Statistics stats) {
            this.docCount.addAndGet(stats.docCount.get());
            this.deletedDocCount.addAndGet(stats.deletedDocCount.get());
            this.rowsCount.addAndGet(stats.rowsCount.get());
            this.queryCount.addAndGet(stats.queryCount.get());
            return this;
        }

        public Map<String, Object> getStatsSnapshot() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("docCount", this.docCount.get());
            result.put("deletedDocCount", this.deletedDocCount.get());
            result.put("rowCount", this.rowsCount.get());
            result.put("queryCount", this.rowsCount.get());
            result.put("skipDocCount", this.skipDocCount.get());
            return result;
        }
    }

    static class DocWrapper
    extends SolrInputDocument {
        Map<String, Object> session;

        DocWrapper() {
        }

        public void setSessionAttribute(String key, Object val) {
            if (this.session == null) {
                this.session = new HashMap<String, Object>();
            }
            this.session.put(key, val);
        }

        public Object getSessionAttribute(String key) {
            return this.session == null ? null : this.session.get(key);
        }
    }
}

