/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.ContextImpl;
import org.apache.solr.handler.dataimport.DataConfig;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.util.AbstractSolrTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataImportHandlerTest
extends AbstractSolrTestCase {
    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        File f = new File("solr/conf/dataimport.properties");
        log.info("Looking for dataimport.properties at: " + f.getAbsolutePath());
        if (f.exists()) {
            log.info("Deleting dataimport.properties");
            if (!f.delete()) {
                log.warn("Could not delete dataimport.properties");
            }
        }
        super.tearDown();
    }

    protected String loadDataConfig(String dataConfigFileName) {
        try {
            SolrCore core = this.h.getCore();
            return SolrWriter.getResourceAsString(core.getResourceLoader().openResource(dataConfigFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void runFullImport(String dataConfig) throws Exception {
        LocalSolrQueryRequest request = this.lrf.makeRequest(new String[]{"command", "full-import", "debug", "on", "clean", "true", "commit", "true", "dataConfig", dataConfig});
        this.h.query("/dataimport", (SolrQueryRequest)request);
    }

    protected void runDeltaImport(String dataConfig) throws Exception {
        LocalSolrQueryRequest request = this.lrf.makeRequest(new String[]{"command", "delta-import", "debug", "on", "clean", "false", "commit", "true", "dataConfig", dataConfig});
        this.h.query("/dataimport", (SolrQueryRequest)request);
    }

    protected void runFullImport(String dataConfig, Map<String, String> extraParams) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("command", "full-import");
        params.put("debug", "on");
        params.put("dataConfig", dataConfig);
        params.put("clean", "true");
        params.put("commit", "true");
        params.putAll(extraParams);
        NamedList l = new NamedList();
        for (Map.Entry e : params.entrySet()) {
            l.add((String)e.getKey(), e.getValue());
        }
        LocalSolrQueryRequest request = new LocalSolrQueryRequest(this.h.getCore(), l);
        this.h.query("/dataimport", (SolrQueryRequest)request);
    }

    public static TestContext getContext(DataConfig.Entity parentEntity, VariableResolverImpl resolver, DataSource parentDataSource, String currProcess, List<Map<String, String>> entityFields, Map<String, String> entityAttrs) {
        if (resolver == null) {
            resolver = new VariableResolverImpl();
        }
        ContextImpl delegate = new ContextImpl(parentEntity, resolver, parentDataSource, currProcess, new HashMap<String, Object>(), null, null);
        return new TestContext(entityAttrs, delegate, entityFields, parentEntity == null);
    }

    public static Map createMap(Object ... args) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (args == null || args.length == 0) {
            return result;
        }
        for (int i = 0; i < args.length - 1; i += 2) {
            result.put(args[i], args[i + 1]);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestContext
    extends Context {
        private final Map<String, String> entityAttrs;
        private final Context delegate;
        private final List<Map<String, String>> entityFields;
        private final boolean root;
        String script;
        String scriptlang;

        public TestContext(Map<String, String> entityAttrs, Context delegate, List<Map<String, String>> entityFields, boolean root) {
            this.entityAttrs = entityAttrs;
            this.delegate = delegate;
            this.entityFields = entityFields;
            this.root = root;
        }

        @Override
        public String getEntityAttribute(String name) {
            return this.entityAttrs == null ? this.delegate.getEntityAttribute(name) : this.entityAttrs.get(name);
        }

        @Override
        public String getResolvedEntityAttribute(String name) {
            return this.entityAttrs == null ? this.delegate.getResolvedEntityAttribute(name) : this.delegate.getVariableResolver().replaceTokens(this.entityAttrs.get(name));
        }

        @Override
        public List<Map<String, String>> getAllEntityFields() {
            return this.entityFields == null ? this.delegate.getAllEntityFields() : this.entityFields;
        }

        @Override
        public VariableResolver getVariableResolver() {
            return this.delegate.getVariableResolver();
        }

        @Override
        public DataSource getDataSource() {
            return this.delegate.getDataSource();
        }

        @Override
        public boolean isRootEntity() {
            return this.root;
        }

        @Override
        public String currentProcess() {
            return this.delegate.currentProcess();
        }

        @Override
        public Map<String, Object> getRequestParameters() {
            return this.delegate.getRequestParameters();
        }

        @Override
        public EntityProcessor getEntityProcessor() {
            return null;
        }

        @Override
        public void setSessionAttribute(String name, Object val, String scope) {
            this.delegate.setSessionAttribute(name, val, scope);
        }

        @Override
        public Object getSessionAttribute(String name, String scope) {
            return this.delegate.getSessionAttribute(name, scope);
        }

        @Override
        public Context getParentContext() {
            return this.delegate.getParentContext();
        }

        @Override
        public DataSource getDataSource(String name) {
            return this.delegate.getDataSource(name);
        }

        @Override
        public SolrCore getSolrCore() {
            return this.delegate.getSolrCore();
        }

        @Override
        public Map<String, Object> getStats() {
            return this.delegate.getStats();
        }

        @Override
        public String getScript() {
            return this.script == null ? this.delegate.getScript() : this.script;
        }

        @Override
        public String getScriptLanguage() {
            return this.scriptlang == null ? this.delegate.getScriptLanguage() : this.scriptlang;
        }

        @Override
        public void deleteDoc(String id) {
        }

        @Override
        public void deleteDocByQuery(String query) {
        }
    }
}

