/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.SolrIndexConfig;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SolrConfig
extends Config {
    public static final String DEFAULT_CONF_FILE = "solrconfig.xml";
    @Deprecated
    public static SolrConfig config = null;
    public static final Collection<Throwable> severeErrors = new HashSet<Throwable>();
    public final int booleanQueryMaxClauseCount;
    public final boolean filtOptEnabled;
    public final int filtOptCacheSize;
    public final float filtOptThreshold;
    public final CacheConfig filterCacheConfig;
    public final CacheConfig queryResultCacheConfig;
    public final CacheConfig documentCacheConfig;
    public final CacheConfig[] userCacheConfigs;
    public final boolean useFilterForSortedQuery;
    public final int queryResultWindowSize;
    public final int queryResultMaxDocsCached;
    public final boolean enableLazyFieldLoading;
    public final float hashSetInverseLoadFactor;
    public final int hashDocSetMaxSize;
    public final SolrIndexConfig defaultIndexConfig = new SolrIndexConfig(this, null, null);
    public final SolrIndexConfig mainIndexConfig = new SolrIndexConfig(this, "mainIndex", this.defaultIndexConfig);
    public final JmxConfiguration jmxConfig;
    private final HttpCachingConfig httpCachingConfig;
    @Deprecated
    private final NamedList pingQueryParams;

    public SolrConfig() throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, DEFAULT_CONF_FILE, null);
    }

    public SolrConfig(String name) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, null);
    }

    public SolrConfig(String name, InputStream is) throws ParserConfigurationException, IOException, SAXException {
        this((SolrResourceLoader)null, name, is);
    }

    public SolrConfig(String instanceDir, String name, InputStream is) throws ParserConfigurationException, IOException, SAXException {
        this(new SolrResourceLoader(instanceDir), name, is);
    }

    SolrConfig(SolrResourceLoader loader, String name, InputStream is) throws ParserConfigurationException, IOException, SAXException {
        super(loader, name, is, "/config/");
        this.booleanQueryMaxClauseCount = this.getInt("query/maxBooleanClauses", BooleanQuery.getMaxClauseCount());
        this.filtOptEnabled = this.getBool("query/boolTofilterOptimizer/@enabled", false);
        this.filtOptCacheSize = this.getInt("query/boolTofilterOptimizer/@cacheSize", 32);
        this.filtOptThreshold = this.getFloat("query/boolTofilterOptimizer/@threshold", 0.05f);
        this.useFilterForSortedQuery = this.getBool("query/useFilterForSortedQuery", false);
        this.queryResultWindowSize = this.getInt("query/queryResultWindowSize", 1);
        this.queryResultMaxDocsCached = this.getInt("query/queryResultMaxDocsCached", Integer.MAX_VALUE);
        this.enableLazyFieldLoading = this.getBool("query/enableLazyFieldLoading", false);
        this.filterCacheConfig = CacheConfig.getConfig(this, "query/filterCache");
        this.queryResultCacheConfig = CacheConfig.getConfig(this, "query/queryResultCache");
        this.documentCacheConfig = CacheConfig.getConfig(this, "query/documentCache");
        this.userCacheConfigs = CacheConfig.getMultipleConfigs(this, "query/cache");
        SolrIndexSearcher.initRegenerators(this);
        this.hashSetInverseLoadFactor = 1.0f / this.getFloat("//HashDocSet/@loadFactor", 0.75f);
        this.hashDocSetMaxSize = this.getInt("//HashDocSet/@maxSize", 3000);
        this.pingQueryParams = SolrConfig.readPingQueryParams(this);
        this.httpCachingConfig = new HttpCachingConfig(this);
        Node jmx = this.getNode("jmx", false);
        this.jmxConfig = jmx != null ? new JmxConfiguration(true, this.get("jmx/@agentId", null), this.get("jmx/@serviceUrl", null)) : new JmxConfiguration(false, null, null);
        Config.log.info("Loaded SolrConfig: " + name);
        config = this;
    }

    public HttpCachingConfig getHttpCachingConfig() {
        return this.httpCachingConfig;
    }

    private static NamedList readPingQueryParams(SolrConfig config) {
        String urlSnippet = config.get("admin/pingQuery", "").trim();
        StringTokenizer qtokens = new StringTokenizer(urlSnippet, "&");
        NamedList params = new NamedList();
        while (qtokens.hasMoreTokens()) {
            String tok = qtokens.nextToken();
            String[] split = tok.split("=", 2);
            params.add(split[0], (Object)split[1]);
        }
        return params;
    }

    @Deprecated
    public SolrQueryRequest getPingQueryRequest(SolrCore core) {
        return new LocalSolrQueryRequest(core, this.pingQueryParams);
    }

    public static class HttpCachingConfig {
        private static final String CACHE_PRE = "requestDispatcher/httpCaching/";
        private static final Pattern MAX_AGE = Pattern.compile("\\bmax-age=(\\d+)");
        private final boolean never304;
        private final String etagSeed;
        private final String cacheControlHeader;
        private final Long maxAge;
        private final LastModFrom lastModFrom;

        private HttpCachingConfig(SolrConfig conf) {
            this.never304 = conf.getBool("requestDispatcher/httpCaching/@never304", false);
            this.etagSeed = conf.get("requestDispatcher/httpCaching/@etagSeed", "Solr");
            this.lastModFrom = LastModFrom.parse(conf.get("requestDispatcher/httpCaching/@lastModFrom", "openTime"));
            this.cacheControlHeader = conf.get("requestDispatcher/httpCaching/cacheControl", null);
            Long tmp = null;
            if (null != this.cacheControlHeader) {
                try {
                    Matcher ttlMatcher = MAX_AGE.matcher(this.cacheControlHeader);
                    String ttlStr = ttlMatcher.find() ? ttlMatcher.group(1) : null;
                    tmp = null != ttlStr && !"".equals(ttlStr) ? Long.valueOf(ttlStr) : null;
                }
                catch (Exception e) {
                    Config.log.log(Level.WARNING, "Ignoring exception while attempting to extract max-age from cacheControl config: " + this.cacheControlHeader, e);
                }
            }
            this.maxAge = tmp;
        }

        public boolean isNever304() {
            return this.never304;
        }

        public String getEtagSeed() {
            return this.etagSeed;
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public Long getMaxAge() {
            return this.maxAge;
        }

        public LastModFrom getLastModFrom() {
            return this.lastModFrom;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum LastModFrom {
            OPENTIME,
            DIRLASTMOD,
            BOGUS;


            public static LastModFrom parse(String s) {
                try {
                    return LastModFrom.valueOf(s.toUpperCase());
                }
                catch (Exception e) {
                    Config.log.log(Level.WARNING, "Unrecognized value for lastModFrom: " + s, e);
                    return BOGUS;
                }
            }
        }
    }

    public static class JmxConfiguration {
        public boolean enabled = false;
        public String agentId;
        public String serviceUrl;

        public JmxConfiguration(boolean enabled, String agentId, String serviceUrl) {
            this.enabled = enabled;
            this.agentId = agentId;
            this.serviceUrl = serviceUrl;
        }
    }
}

