/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.SynonymMap;

public class SynonymFilter
extends TokenFilter {
    private final SynonymMap map;
    private Iterator<Token> replacement;
    private LinkedList<Token> buffer;
    private LinkedList<Token> matched;

    public SynonymFilter(TokenStream in, SynonymMap map) {
        super(in);
        this.map = map;
    }

    public Token next(Token target) throws IOException {
        while (this.replacement == null || !this.replacement.hasNext()) {
            SynonymMap result;
            Token firstTok = this.nextTok(target);
            if (firstTok == null) {
                return null;
            }
            SynonymMap synonymMap = result = this.map.submap != null ? this.map.submap.get(firstTok.termBuffer(), 0, firstTok.termLength()) : null;
            if (result == null) {
                return firstTok;
            }
            this.matched = new LinkedList();
            if ((result = this.match(result)) == null) {
                return firstTok;
            }
            ArrayList<Token> generated = new ArrayList<Token>(result.synonyms.length + this.matched.size() + 1);
            Token lastTok = this.matched.isEmpty() ? firstTok : this.matched.getLast();
            boolean includeOrig = result.includeOrig();
            Token origTok = includeOrig ? firstTok : null;
            int origPos = firstTok.getPositionIncrement();
            int repPos = 0;
            int pos = 0;
            for (int i = 0; i < result.synonyms.length; ++i) {
                Token repTok = result.synonyms[i];
                Token newTok = new Token(firstTok.startOffset(), lastTok.endOffset(), firstTok.type());
                newTok.setTermBuffer(repTok.termBuffer(), 0, repTok.termLength());
                repPos += repTok.getPositionIncrement();
                if (i == 0) {
                    repPos = origPos;
                }
                while (origTok != null && origPos <= repPos) {
                    origTok.setPositionIncrement(origPos - pos);
                    generated.add(origTok);
                    pos += origTok.getPositionIncrement();
                    origTok = this.matched.isEmpty() ? null : this.matched.removeFirst();
                    if (origTok == null) continue;
                    origPos += origTok.getPositionIncrement();
                }
                newTok.setPositionIncrement(repPos - pos);
                generated.add(newTok);
                pos += newTok.getPositionIncrement();
            }
            while (origTok != null) {
                origTok.setPositionIncrement(origPos - pos);
                generated.add(origTok);
                pos += origTok.getPositionIncrement();
                origTok = this.matched.isEmpty() ? null : this.matched.removeFirst();
                if (origTok == null) continue;
                origPos += origTok.getPositionIncrement();
            }
            this.replacement = generated.iterator();
        }
        return this.replacement.next();
    }

    private Token nextTok() throws IOException {
        if (this.buffer != null && !this.buffer.isEmpty()) {
            return this.buffer.removeFirst();
        }
        return this.input.next();
    }

    private Token nextTok(Token target) throws IOException {
        if (this.buffer != null && !this.buffer.isEmpty()) {
            return this.buffer.removeFirst();
        }
        return this.input.next(target);
    }

    private void pushTok(Token t) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addFirst(t);
    }

    private SynonymMap match(SynonymMap map) throws IOException {
        Token tok;
        SynonymMap result = null;
        if (map.submap != null && (tok = this.nextTok()) != null) {
            SynonymMap subMap = map.submap.get(tok.termBuffer(), 0, tok.termLength());
            if (subMap != null) {
                result = this.match(subMap);
            }
            if (result != null) {
                this.matched.addFirst(tok);
            } else {
                this.pushTok(tok);
            }
        }
        if (result == null && map.synonyms != null) {
            result = map;
        }
        return result;
    }
}

