/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.PatternReplaceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternReplaceFilterFactory
extends BaseTokenFilterFactory {
    Pattern p;
    String replacement;
    boolean all = true;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        try {
            this.p = Pattern.compile(args.get("pattern"));
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException("Configuration Error: 'pattern' can not be parsed in " + this.getClass().getName(), e);
        }
        this.replacement = args.get("replacement");
        String r = args.get("replace");
        if (null != r) {
            if (r.equals("all")) {
                this.all = true;
            } else if (r.equals("first")) {
                this.all = false;
            } else {
                throw new RuntimeException("Configuration Error: 'replace' must be 'first' or 'all' in " + this.getClass().getName());
            }
        }
    }

    public PatternReplaceFilter create(TokenStream input) {
        return new PatternReplaceFilter(input, this.p, this.replacement, this.all);
    }
}

