/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;
import org.seasar.robot.extractor.ExtractorFactory;
import org.seasar.robot.helper.MimeTypeHelper;
import org.seasar.robot.util.IgnoreCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(ZipExtractor.class);
    @Resource
    protected ArchiveStreamFactory archiveStreamFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
        if (mimeTypeHelper == null) {
            throw new RobotSystemException("MimeTypeHelper is unavailable.");
        }
        ExtractorFactory extractorFactory = (ExtractorFactory)SingletonS2Container.getComponent((String)"extractorFactory");
        if (extractorFactory == null) {
            throw new RobotSystemException("ExtractorFactory is unavailable.");
        }
        StringBuilder buf = new StringBuilder(1000);
        ArchiveInputStream ais = null;
        try {
            ais = this.archiveStreamFactory.createArchiveInputStream(in);
            ZipArchiveEntry entry = null;
            while ((entry = (ZipArchiveEntry)ais.getNextEntry()) != null) {
                Extractor extractor;
                String filename = entry.getName();
                String mimeType = mimeTypeHelper.getContentType(null, filename);
                if (mimeType == null || (extractor = extractorFactory.getExtractor(mimeType)) == null) continue;
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("resourceName", filename);
                    buf.append(extractor.getText(new IgnoreCloseInputStream((InputStream)ais), map).getContent());
                    buf.append('\n');
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Exception in an internal extractor.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            block10: {
                try {
                    if (buf.length() != 0) break block10;
                    throw new ExtractException("Could not extract a content.", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ais);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)ais);
        }
        IOUtils.closeQuietly((InputStream)ais);
        return new ExtractData(buf.toString());
    }
}

