/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotCrawlAccessException;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.client.S2RobotClient;
import org.seasar.robot.client.fs.ChildUrlsException;
import org.seasar.robot.entity.ResponseData;
import org.seasar.robot.helper.ContentLengthHelper;
import org.seasar.robot.helper.MimeTypeHelper;
import org.seasar.robot.util.TemporaryFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemClient
implements S2RobotClient {
    private final Logger logger = LoggerFactory.getLogger(FileSystemClient.class);
    protected String charset = "UTF-8";
    @Binding(bindingType=BindingType.MAY)
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    private Map<String, Object> initParamMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResponseData doGet(String uri) {
        File file;
        ResponseData responseData;
        block14: {
            responseData = new ResponseData();
            responseData.setMethod("GET");
            uri = this.preprocessUri(uri);
            responseData.setUrl(uri);
            String path = null;
            try {
                path = new URI(uri).getPath();
            }
            catch (URISyntaxException e) {
                this.logger.warn("Could not parse url: " + uri, (Throwable)e);
            }
            file = new File(this.decodeUri(path));
            if (!file.isFile()) break block14;
            MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)SingletonS2Container.getComponent((String)"mimeTypeHelper");
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)is, file.getName()));
            }
            catch (Exception e) {
                try {
                    responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
            responseData.setContentLength(file.length());
            if (this.contentLengthHelper != null) {
                long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                if (responseData.getContentLength() > maxLength) {
                    throw new RobotCrawlAccessException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + uri);
                }
            }
            responseData.setHttpStatusCode(200);
            responseData.setCharSet(this.geCharSet(file));
            responseData.setLastModified(new Date(file.lastModified()));
            if (file.canRead()) {
                File outputFile = null;
                try {
                    outputFile = File.createTempFile("s2robot-FileSystemClient-", ".out");
                    outputFile.deleteOnExit();
                    FileUtil.copy((File)file, (File)outputFile);
                    responseData.setResponseBody(new TemporaryFileInputStream(outputFile));
                    return responseData;
                }
                catch (Exception e) {
                    this.logger.warn("I/O Exception.", (Throwable)e);
                    responseData.setHttpStatusCode(500);
                    if (outputFile == null || outputFile.delete()) return responseData;
                    this.logger.warn("Could not delete " + outputFile.getAbsolutePath());
                }
                return responseData;
            } else {
                responseData.setHttpStatusCode(403);
            }
            return responseData;
        }
        if (file.isDirectory()) {
            HashSet<String> childUrlSet = new HashSet<String>();
            File[] files = file.listFiles();
            if (files == null) throw new ChildUrlsException(childUrlSet);
            for (File f : files) {
                String chileUri = f.toURI().toASCIIString();
                childUrlSet.add(chileUri);
            }
            throw new ChildUrlsException(childUrlSet);
        }
        responseData.setHttpStatusCode(404);
        responseData.setCharSet(this.charset);
        responseData.setContentLength(0L);
        return responseData;
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new RobotSystemException("The uri is empty.");
        }
        if (!uri.startsWith("file:")) {
            uri = "file://" + uri;
        }
        try {
            StringBuilder buf = new StringBuilder(uri.length() + 100);
            for (char c : uri.toCharArray()) {
                String str = String.valueOf(c);
                if (StringUtils.isAsciiPrintable((String)str) && c != ' ') {
                    buf.append(c);
                    continue;
                }
                buf.append(URLEncoder.encode(str, this.charset));
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            return uri;
        }
    }

    protected String decodeUri(String uri) {
        if (StringUtil.isBlank((String)uri)) {
            return uri;
        }
        try {
            return URLDecoder.decode(uri, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RobotSystemException("Unsupported encoding: " + this.charset, e);
        }
    }

    protected String geCharSet(File file) {
        return this.charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void setInitParameterMap(Map<String, Object> params) {
        this.initParamMap = params;
    }
}

