/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.HashSet;
import java.util.Set;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.SafeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLContentHandler
extends SafeContentHandler {
    public static final String XHTML = "http://www.w3.org/1999/xhtml";
    private static final char[] NL = new char[]{'\n'};
    private static final char[] TAB = new char[]{'\t'};
    private static final Set<String> INDENT = new HashSet<String>(){
        {
            this.add("li");
            this.add("dd");
            this.add("dt");
            this.add("td");
            this.add("th");
        }
    };
    private static final Set<String> ENDLINE = new HashSet<String>(){
        {
            this.add("p");
            this.add("h1");
            this.add("h2");
            this.add("h3");
            this.add("h4");
            this.add("h5");
            this.add("h6");
            this.add("div");
            this.add("ul");
            this.add("ol");
            this.add("dl");
            this.add("pre");
            this.add("hr");
            this.add("blockquote");
            this.add("address");
            this.add("fieldset");
            this.add("table");
            this.add("form");
            this.add("noscript");
            this.add("li");
            this.add("dt");
            this.add("dd");
            this.add("noframes");
            this.add("br");
            this.add("tr");
        }
    };
    private final Metadata metadata;
    private boolean started = false;

    public XHTMLContentHandler(ContentHandler handler, Metadata metadata) {
        super(handler);
        this.metadata = metadata;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.startPrefixMapping("", XHTML);
    }

    private void lazyStartDocument() throws SAXException {
        if (!this.started) {
            this.started = true;
            this.startElement("html");
            this.startElement("head");
            this.startElement("title");
            String title = this.metadata.get("title");
            if (title != null && title.length() > 0) {
                this.characters(title);
            }
            this.endElement("title");
            this.endElement("head");
            this.startElement("body");
        }
    }

    public void endDocument() throws SAXException {
        this.lazyStartDocument();
        this.endElement("body");
        this.endElement("html");
        this.endPrefixMapping("");
        super.endDocument();
    }

    public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
        this.lazyStartDocument();
        if (XHTML.equals(uri) && INDENT.contains(local)) {
            this.ignorableWhitespace(TAB, 0, TAB.length);
        }
        super.startElement(uri, local, name, attributes);
    }

    public void endElement(String uri, String local, String name) throws SAXException {
        super.endElement(uri, local, name);
        if (XHTML.equals(uri) && ENDLINE.contains(local)) {
            this.ignorableWhitespace(NL, 0, NL.length);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lazyStartDocument();
        super.characters(ch, start, length);
    }

    public void startElement(String name) throws SAXException {
        this.startElement(XHTML, name, name, new AttributesImpl());
    }

    public void startElement(String name, String attribute, String value) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(XHTML, attribute, attribute, "CDATA", value);
        this.startElement(XHTML, name, name, attributes);
    }

    public void endElement(String name) throws SAXException {
        this.endElement(XHTML, name, name);
    }

    public void characters(String characters) throws SAXException {
        this.characters(characters.toCharArray(), 0, characters.length());
    }

    public void element(String name, String value) throws SAXException {
        this.startElement(name);
        this.characters(value);
        this.endElement(name);
    }
}

