/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.request.QueryResponseWriter;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.servlet.SolrServletRequest;

@Deprecated
public class SolrServlet
extends HttpServlet {
    final Logger log = Logger.getLogger(SolrServlet.class.getName());
    private boolean hasMulticore = false;

    public void init() throws ServletException {
        this.log.info("SolrServlet.init()");
        String instanceDir = SolrResourceLoader.locateInstanceDir();
        File fconf = new File(instanceDir, "solr.xml");
        this.hasMulticore = fconf.exists();
        this.log.info("SolrServlet.init() done");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.hasMulticore) {
            response.sendError(400, "Missing solr core name in path");
            return;
        }
        SolrCore core = SolrCore.getSolrCore();
        SolrServletRequest solrReq = new SolrServletRequest(core, request);
        SolrQueryResponse solrRsp = new SolrQueryResponse();
        try {
            SolrRequestHandler handler = core.getRequestHandler(solrReq.getQueryType());
            if (handler == null) {
                this.log.warning("Unknown Request Handler '" + solrReq.getQueryType() + "' :" + solrReq);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Request Handler '" + solrReq.getQueryType() + "'", true);
            }
            core.execute(handler, solrReq, solrRsp);
            if (solrRsp.getException() == null) {
                QueryResponseWriter responseWriter = core.getQueryResponseWriter(solrReq);
                response.setContentType(responseWriter.getContentType(solrReq, solrRsp));
                PrintWriter out = response.getWriter();
                responseWriter.write(out, solrReq, solrRsp);
            } else {
                Exception e = solrRsp.getException();
                int rc = 500;
                if (e instanceof SolrException) {
                    rc = ((SolrException)((Object)e)).code();
                }
                this.sendErr(rc, SolrException.toStr((Throwable)e), request, response);
            }
        }
        catch (SolrException e) {
            if (!e.logged) {
                SolrException.log((Logger)this.log, (Throwable)e);
            }
            this.sendErr(e.code(), SolrException.toStr((Throwable)e), request, response);
        }
        catch (Throwable e) {
            SolrException.log((Logger)this.log, (Throwable)e);
            this.sendErr(500, SolrException.toStr((Throwable)e), request, response);
        }
        finally {
            solrReq.close();
        }
    }

    final void sendErr(int rc, String msg, HttpServletRequest request, HttpServletResponse response) {
        try {
            try {
                response.setContentType("text/plain; charset=UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                response.setStatus(rc);
            }
            catch (Exception e) {
                // empty catch block
            }
            PrintWriter writer = response.getWriter();
            writer.write(msg);
        }
        catch (IOException e) {
            SolrException.log((Logger)this.log, (Throwable)e);
        }
    }
}

