/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SortSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QParser {
    String qstr;
    SolrParams params;
    SolrParams localParams;
    SolrQueryRequest req;
    int recurseCount;
    Query query;

    public QParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        this.qstr = qstr;
        this.localParams = localParams;
        this.params = params;
        this.req = req;
    }

    public abstract Query parse() throws ParseException;

    public SolrParams getLocalParams() {
        return this.localParams;
    }

    public void setLocalParams(SolrParams localParams) {
        this.localParams = localParams;
    }

    public SolrParams getParams() {
        return this.params;
    }

    public void setParams(SolrParams params) {
        this.params = params;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public void setReq(SolrQueryRequest req) {
        this.req = req;
    }

    public String getString() {
        return this.qstr;
    }

    public void setString(String s) {
        this.qstr = s;
    }

    public Query getQuery() throws ParseException {
        if (this.query == null) {
            this.query = this.parse();
        }
        return this.query;
    }

    private void checkRecurse() throws ParseException {
        if (this.recurseCount++ >= 100) {
            throw new ParseException("Infinite Recursion detected parsing query '" + this.qstr + "'");
        }
    }

    protected String getParam(String name) {
        String val;
        if (this.localParams != null && (val = this.localParams.get(name)) != null) {
            return val;
        }
        return this.params.get(name);
    }

    public QParser subQuery(String q, String defaultType) throws ParseException {
        this.checkRecurse();
        if (defaultType == null && this.localParams != null) {
            defaultType = this.localParams.get("defType");
        }
        QParser nestedParser = QParser.getParser(q, defaultType, this.getReq());
        nestedParser.recurseCount = this.recurseCount--;
        return nestedParser;
    }

    public SortSpec getSort(boolean useGlobalParams) throws ParseException {
        this.getQuery();
        String sortStr = null;
        String startS = null;
        String rowsS = null;
        if (this.localParams != null) {
            sortStr = this.localParams.get("sort");
            startS = this.localParams.get("start");
            rowsS = this.localParams.get("rows");
            if (sortStr != null || startS != null || rowsS != null) {
                useGlobalParams = false;
            }
        }
        if (useGlobalParams) {
            if (sortStr == null) {
                sortStr = this.params.get("sort");
            }
            if (startS == null) {
                startS = this.params.get("start");
            }
            if (rowsS == null) {
                rowsS = this.params.get("rows");
            }
        }
        int start = startS != null ? Integer.parseInt(startS) : 0;
        int rows = rowsS != null ? Integer.parseInt(rowsS) : 10;
        Sort sort = null;
        if (sortStr != null) {
            sort = QueryParsing.parseSort(sortStr, this.req.getSchema());
        }
        return new SortSpec(sort, start, rows);
    }

    public String[] getDefaultHighlightFields() {
        return new String[0];
    }

    public Query getHighlightQuery() throws ParseException {
        return this.getQuery();
    }

    public void addDebugInfo(NamedList<Object> debugInfo) {
        debugInfo.add("QParser", (Object)this.getClass().getSimpleName());
    }

    public static QParser getParser(String qstr, String defaultType, SolrQueryRequest req) throws ParseException {
        String type;
        SolrParams localParams = QueryParsing.getLocalParams(qstr, req.getParams());
        if (localParams == null) {
            type = defaultType;
        } else {
            String localType = localParams.get("type");
            type = localType == null ? defaultType : localType;
            qstr = localParams.get("v");
        }
        type = type == null ? QParserPlugin.DEFAULT_QTYPE : type;
        QParserPlugin qplug = req.getCore().getQueryPlugin(type);
        return qplug.createParser(qstr, localParams, req.getParams(), req);
    }
}

