/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.util.SolrPluginUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DismaxQParser
extends QParser {
    private static String IMPOSSIBLE_FIELD_NAME = "\ufffc\ufffc\ufffc";
    Map<String, Float> queryFields;
    Query parsedUserQuery;
    private String[] boostParams;
    private List<Query> boostQueries;
    private Query altUserQuery;
    private QParser altQParser;

    public DismaxQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Query parse() throws ParseException {
        String[] boostFuncs;
        SolrParams solrParams = this.localParams == null ? this.params : new DefaultSolrParams(this.localParams, this.params);
        IndexSchema schema = this.req.getSchema();
        this.queryFields = SolrPluginUtils.parseFieldBoosts(solrParams.getParams("qf"));
        Map<String, Float> phraseFields = SolrPluginUtils.parseFieldBoosts(solrParams.getParams("pf"));
        float tiebreaker = solrParams.getFloat("tie", 0.0f);
        int pslop = solrParams.getInt("ps", 0);
        int qslop = solrParams.getInt("qs", 0);
        SolrQueryParser p = schema.getSolrQueryParser(null);
        SolrPluginUtils.DisjunctionMaxQueryParser up = new SolrPluginUtils.DisjunctionMaxQueryParser(schema, IMPOSSIBLE_FIELD_NAME);
        up.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, this.queryFields);
        up.setPhraseSlop(qslop);
        SolrPluginUtils.DisjunctionMaxQueryParser pp = new SolrPluginUtils.DisjunctionMaxQueryParser(schema, IMPOSSIBLE_FIELD_NAME);
        pp.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, phraseFields);
        pp.setPhraseSlop(pslop);
        BooleanQuery query = new BooleanQuery(true);
        this.parsedUserQuery = null;
        String userQuery = this.getString();
        this.altUserQuery = null;
        if (userQuery == null || userQuery.trim().length() < 1) {
            String altQ = solrParams.get("q.alt");
            if (altQ == null) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing query string");
            this.altQParser = this.subQuery(altQ, null);
            this.altUserQuery = this.altQParser.parse();
            query.add(this.altUserQuery, BooleanClause.Occur.MUST);
        } else {
            Query dis;
            userQuery = ((Object)SolrPluginUtils.partialEscape(SolrPluginUtils.stripUnbalancedQuotes(userQuery))).toString();
            userQuery = ((Object)SolrPluginUtils.stripIllegalOperators(userQuery)).toString();
            String minShouldMatch = solrParams.get("mm", "100%");
            this.parsedUserQuery = dis = up.parse(userQuery);
            if (dis instanceof BooleanQuery) {
                BooleanQuery t = new BooleanQuery();
                SolrPluginUtils.flattenBooleanQuery(t, (BooleanQuery)dis);
                SolrPluginUtils.setMinShouldMatch(t, minShouldMatch);
                this.parsedUserQuery = t;
            }
            query.add(this.parsedUserQuery, BooleanClause.Occur.MUST);
            String userPhraseQuery = userQuery.replace("\"", "");
            Query phrase = pp.parse("\"" + userPhraseQuery + "\"");
            if (null != phrase) {
                query.add(phrase, BooleanClause.Occur.SHOULD);
            }
        }
        this.boostParams = solrParams.getParams("bq");
        this.boostQueries = null;
        if (this.boostParams != null && this.boostParams.length > 0) {
            this.boostQueries = new ArrayList<Query>();
            for (String qs : this.boostParams) {
                if (qs.trim().length() == 0) continue;
                Query q = this.subQuery(qs, null).parse();
                this.boostQueries.add(q);
            }
        }
        if (null != this.boostQueries) {
            if (1 == this.boostQueries.size() && 1 == this.boostParams.length) {
                Query f = this.boostQueries.get(0);
                if (1.0f == f.getBoost() && f instanceof BooleanQuery) {
                    for (Object c : ((BooleanQuery)f).clauses()) {
                        query.add((BooleanClause)c);
                    }
                } else {
                    query.add(f, BooleanClause.Occur.SHOULD);
                }
            } else {
                for (Query f : this.boostQueries) {
                    query.add(f, BooleanClause.Occur.SHOULD);
                }
            }
        }
        if (null == (boostFuncs = solrParams.getParams("bf")) || 0 == boostFuncs.length) return query;
        for (String boostFunc : boostFuncs) {
            if (null == boostFunc || "".equals(boostFunc)) continue;
            Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(boostFunc);
            for (String f : ff.keySet()) {
                Query fq = this.subQuery(f, FunctionQParserPlugin.NAME).parse();
                Float b = ff.get(f);
                if (null != b) {
                    fq.setBoost(b.floatValue());
                }
                query.add(fq, BooleanClause.Occur.SHOULD);
            }
        }
        return query;
    }

    @Override
    public String[] getDefaultHighlightFields() {
        String[] highFields = this.queryFields.keySet().toArray(new String[0]);
        return highFields;
    }

    @Override
    public Query getHighlightQuery() throws ParseException {
        return this.parsedUserQuery;
    }

    @Override
    public void addDebugInfo(NamedList<Object> debugInfo) {
        super.addDebugInfo(debugInfo);
        debugInfo.add("altquerystring", (Object)this.altUserQuery);
        if (null != this.boostQueries) {
            debugInfo.add("boost_queries", (Object)this.boostParams);
            debugInfo.add("parsed_boost_queries", QueryParsing.toString(this.boostQueries, this.req.getSchema()));
        }
        debugInfo.add("boostfuncs", (Object)this.req.getParams().getParams("bf"));
    }
}

