/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryParser.ParseException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.DistribFieldFacet;
import org.apache.solr.handler.component.FacetInfo;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardFacetCount;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.util.OpenBitSet;

public class FacetComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "facet";

    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.setNeedDocSet(true);
            rb.doFacets = true;
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doFacets) {
            SolrParams params = rb.req.getParams();
            SimpleFacets f = new SimpleFacets(rb.req, rb.getResults().docSet, params);
            rb.rsp.add("facet_counts", f.getFacetCounts());
        }
    }

    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doFacets) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                List<String> fqueries = rb._facetInfo._toRefine[shardNum];
                if (fqueries == null || fqueries.size() == 0) continue;
                String shard = rb.shards[shardNum];
                ShardRequest refine = null;
                boolean newRequest = false;
                for (ShardRequest sreq : rb.outgoing) {
                    if ((sreq.purpose & 0x40) == 0 || !(sreq.shards != null & sreq.shards.length == 1) || !sreq.shards[0].equals(shard)) continue;
                    refine = sreq;
                    break;
                }
                if (refine == null) {
                    newRequest = true;
                    refine = new ShardRequest();
                    refine.shards = new String[]{rb.shards[shardNum]};
                    refine.params = new ModifiableSolrParams(rb.req.getParams());
                    refine.params.remove("start");
                    refine.params.set("rows", new String[]{"0"});
                }
                refine.purpose |= 0x20;
                refine.params.set(COMPONENT_NAME, new String[]{"true"});
                refine.params.remove("facet.field");
                refine.params.set("facet.query", fqueries.toArray(new String[fqueries.size()]));
                if (!newRequest) continue;
                rb.addRequest(this, refine);
            }
        }
        return ResponseBuilder.STAGE_DONE;
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x10;
            FacetInfo fi = rb._facetInfo;
            if (fi == null) {
                rb._facetInfo = fi = new FacetInfo();
                fi.parse(rb.req.getParams(), rb);
            }
            sreq.params.remove("facet.mincount");
            sreq.params.remove("facet.offset");
            sreq.params.remove("facet.limit");
            for (DistribFieldFacet dff : fi.topFacets.values()) {
                String paramStart = "f." + dff.field + '.';
                sreq.params.remove(paramStart + "facet.mincount");
                sreq.params.remove(paramStart + "facet.offset");
                if (dff.limit > 0) {
                    dff.initialLimit = dff.offset + dff.limit;
                    dff.initialLimit = (int)((double)dff.initialLimit * 1.5) + 10;
                } else {
                    dff.initialLimit = dff.limit;
                }
                sreq.params.set(paramStart + "facet.limit", dff.initialLimit);
            }
        } else {
            sreq.params.set(COMPONENT_NAME, new String[]{"false"});
        }
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 0x10) != 0) {
            this.countFacets(rb, sreq);
        } else if ((sreq.purpose & 0x20) != 0) {
            this.refineFacets(rb, sreq);
        }
    }

    private void countFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            int shardNum = rb.getShardNum(srsp.getShard());
            NamedList facet_counts = (NamedList)srsp.getSolrResponse().getResponse().get("facet_counts");
            NamedList facet_queries = (NamedList)facet_counts.get("facet_queries");
            if (facet_queries != null) {
                for (int i = 0; i < facet_queries.size(); ++i) {
                    String facet_q = facet_queries.getName(i);
                    long count = ((Number)facet_queries.getVal(i)).longValue();
                    Long prevCount = fi.queryFacets.get(facet_q);
                    if (prevCount != null) {
                        count += prevCount.longValue();
                    }
                    fi.queryFacets.put(facet_q, count);
                }
            }
            NamedList facet_fields = (NamedList)facet_counts.get("facet_fields");
            for (DistribFieldFacet dff : fi.topFacets.values()) {
                dff.add(shardNum, (NamedList)facet_fields.get(dff.field), dff.initialLimit);
            }
        }
        List[] toRefine = new List[rb.shards.length];
        fi._toRefine = toRefine;
        for (int i = 0; i < toRefine.length; ++i) {
            toRefine[i] = new ArrayList();
        }
        for (DistribFieldFacet dff : fi.topFacets.values()) {
            if (dff.limit <= 0) continue;
            ShardFacetCount[] counts = dff.getSorted();
            int ntop = Math.min(counts.length, dff.offset + dff.limit);
            long smallestCount = counts.length == 0 ? 0L : counts[ntop - 1].count;
            for (int i = 0; i < counts.length; ++i) {
                ShardFacetCount sfc = counts[i];
                String query = null;
                boolean needRefinement = false;
                if (i < ntop) {
                    needRefinement = true;
                } else {
                    long maxCount = sfc.count;
                    for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                        OpenBitSet obs = dff.counted[shardNum];
                        if (obs.get(sfc.termNum)) continue;
                        maxCount += dff.maxPossible(sfc, shardNum);
                    }
                    if (maxCount >= smallestCount) {
                        needRefinement = true;
                    }
                }
                if (!needRefinement) continue;
                for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                    OpenBitSet obs = dff.counted[shardNum];
                    if (obs.get(sfc.termNum) || dff.maxPossible(sfc, shardNum) <= 0L) continue;
                    dff.needRefinements = true;
                    if (query == null) {
                        query = dff.makeQuery(sfc);
                    }
                    toRefine[shardNum].add(query);
                }
            }
        }
    }

    private void refineFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            NamedList facet_counts = (NamedList)srsp.getSolrResponse().getResponse().get("facet_counts");
            NamedList facet_queries = (NamedList)facet_counts.get("facet_queries");
            for (int i = 0; i < facet_queries.size(); ++i) {
                try {
                    ShardFacetCount sfc;
                    String facet_q = facet_queries.getName(i);
                    long count = ((Number)facet_queries.getVal(i)).longValue();
                    SolrParams qparams = QueryParsing.getLocalParams(facet_q, null);
                    if (qparams == null) continue;
                    String field = qparams.get("f");
                    String val = qparams.get("v");
                    DistribFieldFacet dff = fi.topFacets.get(field);
                    if (dff == null || (sfc = dff.counts.get(val)) == null) continue;
                    sfc.count += count;
                    continue;
                }
                catch (ParseException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
    }

    public void finishStage(ResponseBuilder rb) {
        if (!rb.doFacets || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        FacetInfo fi = rb._facetInfo;
        SimpleOrderedMap facet_counts = new SimpleOrderedMap();
        SimpleOrderedMap facet_queries = new SimpleOrderedMap();
        facet_counts.add("facet_queries", (Object)facet_queries);
        for (Map.Entry<String, Long> entry : fi.queryFacets.entrySet()) {
            facet_queries.add(entry.getKey(), (Object)this.num(entry.getValue()));
        }
        SimpleOrderedMap facet_fields = new SimpleOrderedMap();
        facet_counts.add("facet_fields", (Object)facet_fields);
        for (DistribFieldFacet dff : fi.topFacets.values()) {
            NamedList fieldCounts = new NamedList();
            facet_fields.add(dff.field, (Object)fieldCounts);
            ShardFacetCount[] counts = dff.countSorted;
            if (counts == null || dff.needRefinements) {
                counts = dff.getSorted();
            }
            int end = dff.limit < 0 ? counts.length : Math.min(dff.offset + dff.limit, counts.length);
            for (int i = dff.offset; i < end && counts[i].count >= (long)dff.minCount; ++i) {
                fieldCounts.add(counts[i].name, (Object)this.num(counts[i].count));
            }
            if (!dff.missing) continue;
            fieldCounts.add(null, (Object)this.num(dff.missingCount));
        }
        facet_counts.add("facet_dates", (Object)new SimpleOrderedMap());
        rb.rsp.add("facet_counts", facet_counts);
        rb._facetInfo = null;
    }

    private Number num(long val) {
        if (val < Integer.MAX_VALUE) {
            return (int)val;
        }
        return val;
    }

    private Number num(Long val) {
        if (val < Integer.MAX_VALUE) {
            return val.intValue();
        }
        return val;
    }

    public String getDescription() {
        return "Handle Faceting";
    }

    public String getVersion() {
        return "$Revision: 692551 $";
    }

    public String getSourceId() {
        return "$Id: FacetComponent.java 692551 2008-09-05 21:02:35Z yonik $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.3/src/java/org/apache/solr/handler/component/FacetComponent.java $";
    }

    public URL[] getDocs() {
        return null;
    }
}

