/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.commons.codec.Encoder;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class PhoneticFilter
extends TokenFilter {
    protected boolean inject = true;
    protected Encoder encoder = null;
    protected String name = null;
    protected Token save = null;

    public PhoneticFilter(TokenStream in, Encoder encoder, String name, boolean inject) {
        super(in);
        this.encoder = encoder;
        this.name = name;
        this.inject = inject;
    }

    public final Token next(Token in) throws IOException {
        if (this.save != null) {
            Token temp = this.save;
            this.save = null;
            return temp;
        }
        Token t = this.input.next(in);
        if (t != null) {
            String value = new String(t.termBuffer(), 0, t.termLength());
            try {
                value = this.encoder.encode((Object)value).toString();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (this.inject) {
                this.save = (Token)t.clone();
                this.save.setPositionIncrement(0);
                this.save.setTermBuffer(value.toCharArray(), 0, value.length());
            } else {
                t.setTermBuffer(value.toCharArray(), 0, value.length());
            }
        }
        return t;
    }
}

