/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.el.GreekCharsets;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.SolrException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreekLowerCaseFilterFactory
extends BaseTokenFilterFactory {
    private static Map<String, char[]> CHARSETS = new HashMap<String, char[]>();
    private char[] charset = GreekCharsets.UnicodeGreek;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String charsetName = args.get("charset");
        if (null != charsetName) {
            this.charset = CHARSETS.get(charsetName);
        }
        if (null == this.charset) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Don't understand charset: " + charsetName);
        }
    }

    public GreekLowerCaseFilter create(TokenStream in) {
        return new GreekLowerCaseFilter(in, this.charset);
    }

    static {
        CHARSETS.put("UnicodeGreek", GreekCharsets.UnicodeGreek);
        CHARSETS.put("ISO", GreekCharsets.ISO);
        CHARSETS.put("CP1253", GreekCharsets.CP1253);
    }
}

