/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.HttpUtils;
import org.mobylet.core.util.PathUtils;
import org.mobylet.core.util.StringUtils;

public class ResourceUtils {
    public static InputStream getResourceFileOrInputStream(String path) {
        if (StringUtils.isEmpty(path)) {
            return null;
        }
        if (PathUtils.isNetworkPath(path)) {
            HttpURLConnection httpURLConnection = HttpUtils.getHttpUrlConnection(path);
            try {
                return httpURLConnection.getInputStream();
            }
            catch (IOException e) {
                throw new MobyletRuntimeException("[URL IO-Exception] path = " + path, e);
            }
        }
        File f = new File(path);
        if (f != null && f.exists() && f.canRead()) {
            try {
                return new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new MobyletRuntimeException("[File Not Fount] filename = " + path, e);
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ResourceUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResourceAsStream(path);
    }
}

