/*
 * Decompiled with CFR 0.152.
 */
package org.junit.tests;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;

public class RunnerTest {
    private boolean wasRun;

    @Test
    public void newTestCount() {
        JUnitCore runner = new JUnitCore();
        MyListener listener = new MyListener();
        runner.addListener(listener);
        runner.run(Example.class);
        Assert.assertEquals(1, listener.testCount);
    }

    @Test
    public void oldTestCount() {
        JUnitCore runner = new JUnitCore();
        MyListener listener = new MyListener();
        runner.addListener(listener);
        runner.run(ExampleTest.class);
        Assert.assertEquals(1, listener.testCount);
    }

    @Test
    public void testFinished() {
        JUnitCore runner = new JUnitCore();
        this.wasRun = false;
        MyListener listener = new MyListener(){

            public void testFinished(Description description) {
                RunnerTest.this.wasRun = true;
            }
        };
        runner.addListener(listener);
        runner.run(NewExample.class);
        Assert.assertTrue(this.wasRun);
    }

    public static class NewExample {
        @Test
        public void empty() {
        }
    }

    public static class ExampleTest
    extends TestCase {
        public void testEmpty() {
        }
    }

    public static class Example {
        @Test
        public void empty() {
        }
    }

    public class MyListener
    extends RunListener {
        int testCount;

        public void testRunStarted(Description description) {
            this.testCount = description.testCount();
        }
    }
}

