/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import java.util.List;
import org.seasar.dbflute.cbean.sqlclause.AbstractSqlClause;
import org.seasar.dbflute.cbean.sqlclause.OrderByClause;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbway.WayOfMySQL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlClauseMySql
extends AbstractSqlClause {
    protected String _fetchScopeSqlSuffix = "";
    protected String _lockSqlSuffix = "";

    public SqlClauseMySql(String tableName) {
        super(tableName);
    }

    @Override
    protected OrderByClause.OrderByNullsSetupper createOrderByNullsSetupper() {
        return this.createOrderByNullsSetupperByCaseWhen();
    }

    @Override
    protected void doFetchFirst() {
        this.doFetchPage();
    }

    @Override
    protected void doFetchPage() {
        this._fetchScopeSqlSuffix = " limit " + this.getPageStartIndex() + ", " + this.getFetchSize();
    }

    @Override
    protected void doClearFetchPageClause() {
        this._fetchScopeSqlSuffix = "";
    }

    @Override
    public SqlClause lockForUpdate() {
        this._lockSqlSuffix = " for update";
        return this;
    }

    @Override
    protected String createSelectHint() {
        return "";
    }

    @Override
    protected String createFromBaseTableHint() {
        return "";
    }

    @Override
    protected String createFromHint() {
        return "";
    }

    @Override
    protected String createSqlSuffix() {
        return this._fetchScopeSqlSuffix + this._lockSqlSuffix;
    }

    @Override
    protected boolean isUpdateSubQueryUseLocalTableSupported() {
        return false;
    }

    public String buildMatchCondition(List<ColumnInfo> textColumnList, String conditionValue, WayOfMySQL.FullTextSearchModifier modifier, String tableDbName, String aliasName) {
        if (textColumnList == null) {
            throw new IllegalArgumentException("The argument 'textColumnList' should not be null!");
        }
        if (textColumnList.isEmpty()) {
            throw new IllegalArgumentException("The argument 'textColumnList' should not be empty list!");
        }
        if (conditionValue == null || conditionValue.length() == 0) {
            throw new IllegalArgumentException("The argument 'conditionValue' should not be null or empty: " + conditionValue);
        }
        if (tableDbName == null || tableDbName.trim().length() == 0) {
            throw new IllegalArgumentException("The argument 'tableDbName' should not be null or trimmed-empty: " + tableDbName);
        }
        if (aliasName == null || aliasName.trim().length() == 0) {
            throw new IllegalArgumentException("The argument 'aliasName' should not be null or trimmed-empty: " + aliasName);
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (ColumnInfo columnInfo : textColumnList) {
            if (columnInfo == null) continue;
            String tableOfColumn = columnInfo.getDBMeta().getTableDbName();
            if (!tableOfColumn.equalsIgnoreCase(tableDbName)) {
                String msg = "The table of the text column should be '" + tableDbName + "'";
                msg = msg + " but the table is '" + tableOfColumn + "': column=" + columnInfo;
                throw new IllegalArgumentException(msg);
            }
            Class<?> propertyType = columnInfo.getPropertyType();
            if (!String.class.isAssignableFrom(propertyType)) {
                String msg = "The text column should be String type:";
                msg = msg + " type=" + propertyType + " column=" + columnInfo;
                throw new IllegalArgumentException(msg);
            }
            String columnDbName = columnInfo.getColumnDbName();
            if (index > 0) {
                sb.append(",");
            }
            sb.append(aliasName).append(".").append(columnDbName);
            ++index;
        }
        sb.insert(0, "match(").append(") against ('").append(conditionValue).append("'");
        if (modifier != null) {
            sb.append(" ").append(modifier.code());
        }
        sb.append(")");
        return sb.toString();
    }
}

