/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractSelectCBCommand;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectScalarCBCommand<RESULT>
extends AbstractSelectCBCommand<RESULT> {
    protected Class<RESULT> _resultType;
    protected SqlClause.SelectClauseType _selectClauseType;

    @Override
    public String getCommandName() {
        this.assertStatus("getCommandName");
        String resultTypeName = this._resultType.getSimpleName();
        String scalarMethodName = this._selectClauseType.toString().toLowerCase();
        return "scalarSelect(" + resultTypeName + ")." + scalarMethodName;
    }

    @Override
    public Class<?> getCommandReturnType() {
        this.assertStatus("getCommandReturnType");
        return this._resultType;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public void beforeGettingSqlExecution() {
        this.assertStatus("beforeGettingSqlExecution");
        ConditionBean cb = this._conditionBean;
        ConditionBeanContext.setConditionBeanOnThread(cb);
        cb.getSqlClause().classifySelectClauseType(this._selectClauseType);
    }

    @Override
    public void afterExecuting() {
        this.assertStatus("afterExecuting");
        ConditionBean cb = this._conditionBean;
        cb.getSqlClause().rollbackSelectClauseType();
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                TnResultSetHandler handler = SelectScalarCBCommand.this.createObjectResultSetHandler(SelectScalarCBCommand.this.getCommandReturnType());
                return SelectScalarCBCommand.this.createSelectCBExecution(SelectScalarCBCommand.this._conditionBeanType, handler);
            }
        };
    }

    @Override
    protected void assertStatus(String methodName) {
        super.assertStatus(methodName);
        if (this._resultType == null) {
            throw new IllegalStateException(this.buildAssertMessage("_resultType", methodName));
        }
        if (this._selectClauseType == null) {
            throw new IllegalStateException(this.buildAssertMessage("_selectClauseType", methodName));
        }
    }

    public void setResultType(Class<RESULT> resultType) {
        this._resultType = resultType;
    }

    public void setSelectClauseType(SqlClause.SelectClauseType selectClauseType) {
        this._selectClauseType = selectClauseType;
    }
}

