/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TXTParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, Map<String, Object> context) throws IOException, SAXException, TikaException {
        String encoding;
        metadata.set("Content-Type", "text/plain");
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        CharsetDetector detector = new CharsetDetector();
        detector.setText(stream);
        for (CharsetMatch match : detector.detectAll()) {
            if (!Charset.isSupported(match.getName())) continue;
            metadata.set("Content-Encoding", match.getName());
            String language = match.getLanguage();
            if (language == null) break;
            metadata.set("Content-Language", match.getLanguage());
            metadata.set("language", match.getLanguage());
            break;
        }
        if ((encoding = metadata.get("Content-Encoding")) == null) {
            throw new TikaException("Text encoding could not be detected and no encoding hint is available in document metadata");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));
            ((Reader)reader).mark(1);
            int bom = ((Reader)reader).read();
            if (bom != 65279) {
                ((Reader)reader).reset();
            }
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            xhtml.startElement("p");
            char[] buffer = new char[4096];
            int n = reader.read(buffer);
            while (n != -1) {
                xhtml.characters(buffer, 0, n);
                n = reader.read(buffer);
            }
            xhtml.endElement("p");
            xhtml.endDocument();
        }
        catch (UnsupportedEncodingException e) {
            throw new TikaException("Unsupported text encoding: " + encoding, (Throwable)e);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        Map<String, Object> context = Collections.emptyMap();
        this.parse(stream, handler, metadata, context);
    }
}

