/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Payload;

public class PrefixAwareTokenFilter
extends TokenStream {
    private TokenStream prefix;
    private TokenStream suffix;
    private Token previousPrefixToken = new Token();
    private boolean prefixExhausted;

    public PrefixAwareTokenFilter(TokenStream prefix, TokenStream suffix) {
        this.suffix = suffix;
        this.prefix = prefix;
        this.prefixExhausted = false;
    }

    public Token next(Token reusableToken) throws IOException {
        Token nextToken;
        assert (reusableToken != null);
        if (!this.prefixExhausted) {
            nextToken = this.prefix.next(reusableToken);
            if (nextToken == null) {
                this.prefixExhausted = true;
            } else {
                this.previousPrefixToken.reinit(nextToken);
                Payload p = this.previousPrefixToken.getPayload();
                if (p != null) {
                    this.previousPrefixToken.setPayload((Payload)p.clone());
                }
                return nextToken;
            }
        }
        if ((nextToken = this.suffix.next(reusableToken)) == null) {
            return null;
        }
        return this.updateSuffixToken(nextToken, this.previousPrefixToken);
    }

    public Token updateSuffixToken(Token suffixToken, Token lastPrefixToken) {
        suffixToken.setStartOffset(lastPrefixToken.endOffset() + suffixToken.startOffset());
        suffixToken.setEndOffset(lastPrefixToken.endOffset() + suffixToken.endOffset());
        return suffixToken;
    }

    public void close() throws IOException {
        this.prefix.close();
        this.suffix.close();
    }

    public void reset() throws IOException {
        super.reset();
        if (this.prefix != null) {
            this.prefixExhausted = false;
            this.prefix.reset();
        }
        if (this.suffix != null) {
            this.suffix.reset();
        }
    }

    public TokenStream getPrefix() {
        return this.prefix;
    }

    public void setPrefix(TokenStream prefix) {
        this.prefix = prefix;
    }

    public TokenStream getSuffix() {
        return this.suffix;
    }

    public void setSuffix(TokenStream suffix) {
        this.suffix = suffix;
    }
}

