/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.common.SolrException;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDataSource
extends DataSource<Iterator<Map<String, Object>>> {
    private static final Logger LOG = Logger.getLogger(JdbcDataSource.class.getName());
    private Callable<Connection> factory;
    private long connLastUsed = 0L;
    private Connection conn;
    private Map<String, Integer> fieldNameVsType = new HashMap<String, Integer>();
    private boolean convertType = false;
    private int batchSize = 500;
    private static final long CONN_TIME_OUT = 10000L;
    private static final int FETCH_SIZE = 500;
    public static final String URL = "url";
    public static final String DRIVER = "driver";
    public static final String CONVERT_TYPE = "convertType";

    @Override
    public void init(Context context, Properties initProps) {
        Object o = initProps.get(CONVERT_TYPE);
        if (o != null) {
            this.convertType = Boolean.parseBoolean(o.toString());
        }
        this.createConnectionFactory(context, initProps);
        String bsz = initProps.getProperty("batchSize");
        if (bsz != null) {
            try {
                this.batchSize = Integer.parseInt(bsz);
                if (this.batchSize == -1) {
                    this.batchSize = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "Invalid batch size: " + bsz);
            }
        }
        for (Map<String, String> map : context.getAllEntityFields()) {
            String n = map.get("column");
            String t = map.get("type");
            if ("sint".equals(t) || "integer".equals(t)) {
                this.fieldNameVsType.put(n, 4);
                continue;
            }
            if ("slong".equals(t) || "long".equals(t)) {
                this.fieldNameVsType.put(n, -5);
                continue;
            }
            if ("float".equals(t) || "sfloat".equals(t)) {
                this.fieldNameVsType.put(n, 6);
                continue;
            }
            if ("double".equals(t) || "sdouble".equals(t)) {
                this.fieldNameVsType.put(n, 8);
                continue;
            }
            if ("date".equals(t)) {
                this.fieldNameVsType.put(n, 91);
                continue;
            }
            if ("boolean".equals(t)) {
                this.fieldNameVsType.put(n, 16);
                continue;
            }
            this.fieldNameVsType.put(n, 12);
        }
    }

    private void createConnectionFactory(final Context context, final Properties initProps) {
        final String url = initProps.getProperty(URL);
        final String driver = initProps.getProperty(DRIVER);
        if (url == null) {
            throw new DataImportHandlerException(500, "JDBC URL cannot be null");
        }
        if (driver != null) {
            try {
                DocBuilder.loadClass(driver, context.getSolrCore());
            }
            catch (ClassNotFoundException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load driver: " + driver, (Throwable)e);
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Driver must be specified");
        }
        this.factory = new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                LOG.info("Creating a connection for entity " + context.getEntityAttribute("name") + " with URL: " + url);
                long start = System.currentTimeMillis();
                Connection c = null;
                try {
                    c = DriverManager.getConnection(url, initProps);
                }
                catch (SQLException e) {
                    Driver d = (Driver)DocBuilder.loadClass(driver, context.getSolrCore()).newInstance();
                    c = d.connect(url, initProps);
                }
                LOG.info("Time taken for getConnection(): " + (System.currentTimeMillis() - start));
                return c;
            }
        };
    }

    @Override
    public Iterator<Map<String, Object>> getData(String query) {
        ResultSetIterator r = new ResultSetIterator(query);
        return r.getIterator();
    }

    private void logError(String msg, Exception e) {
        LOG.log(Level.WARNING, msg, e);
    }

    private List<String> readFieldNames(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> colNames = new ArrayList<String>();
        int count = metaData.getColumnCount();
        for (int i = 0; i < count; ++i) {
            colNames.add(metaData.getColumnLabel(i + 1));
        }
        return colNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() throws Exception {
        long currTime = System.currentTimeMillis();
        if (currTime - this.connLastUsed > 10000L) {
            JdbcDataSource jdbcDataSource = this;
            synchronized (jdbcDataSource) {
                Connection tmpConn = this.factory.call();
                this.close();
                this.connLastUsed = System.currentTimeMillis();
                this.conn = tmpConn;
                return this.conn;
            }
        }
        this.connLastUsed = currTime;
        return this.conn;
    }

    protected void finalize() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultSetIterator {
        ResultSet resultSet;
        Statement stmt = null;
        List<String> colNames;
        Iterator<Map<String, Object>> rSetIterator;

        public ResultSetIterator(String query) {
            try {
                Connection c = JdbcDataSource.this.getConnection();
                this.stmt = c.createStatement(1003, 1007);
                this.stmt.setFetchSize(JdbcDataSource.this.batchSize);
                LOG.finer("Executing SQL: " + query);
                long start = System.currentTimeMillis();
                if (this.stmt.execute(query)) {
                    this.resultSet = this.stmt.getResultSet();
                }
                LOG.finest("Time taken for sql :" + (System.currentTimeMillis() - start));
                this.colNames = JdbcDataSource.this.readFieldNames(this.resultSet.getMetaData());
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Unable to execute query: " + query, e);
            }
            if (this.resultSet == null) {
                this.rSetIterator = new ArrayList().iterator();
                return;
            }
            this.rSetIterator = new Iterator<Map<String, Object>>(){

                @Override
                public boolean hasNext() {
                    return ResultSetIterator.this.hasnext();
                }

                @Override
                public Map<String, Object> next() {
                    return ResultSetIterator.this.getARow();
                }

                @Override
                public void remove() {
                }
            };
        }

        private Iterator<Map<String, Object>> getIterator() {
            return this.rSetIterator;
        }

        private Map<String, Object> getARow() {
            if (this.resultSet == null) {
                return null;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String colName : this.colNames) {
                try {
                    if (!JdbcDataSource.this.convertType) {
                        result.put(colName, this.resultSet.getObject(colName));
                        continue;
                    }
                    Integer type = (Integer)JdbcDataSource.this.fieldNameVsType.get(colName);
                    if (type == null) {
                        type = 12;
                    }
                    switch (type) {
                        case 4: {
                            result.put(colName, this.resultSet.getInt(colName));
                            break;
                        }
                        case 6: {
                            result.put(colName, Float.valueOf(this.resultSet.getFloat(colName)));
                            break;
                        }
                        case -5: {
                            result.put(colName, this.resultSet.getLong(colName));
                            break;
                        }
                        case 8: {
                            result.put(colName, this.resultSet.getDouble(colName));
                            break;
                        }
                        case 91: {
                            result.put(colName, this.resultSet.getDate(colName));
                            break;
                        }
                        case 16: {
                            result.put(colName, this.resultSet.getBoolean(colName));
                            break;
                        }
                        default: {
                            result.put(colName, this.resultSet.getString(colName));
                            break;
                        }
                    }
                }
                catch (SQLException e) {
                    JdbcDataSource.this.logError("Error reading data ", e);
                    throw new DataImportHandlerException(500, "Error reading data from database", e);
                }
            }
            return result;
        }

        private boolean hasnext() {
            if (this.resultSet == null) {
                return false;
            }
            try {
                if (this.resultSet.next()) {
                    return true;
                }
                this.close();
                return false;
            }
            catch (SQLException e) {
                JdbcDataSource.this.logError("Error reading data ", e);
                this.close();
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception e) {
                JdbcDataSource.this.logError("Exception while closing result set", e);
            }
            finally {
                this.resultSet = null;
                this.stmt = null;
            }
        }
    }
}

