/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.DocBuilder;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.apache.solr.handler.dataimport.ScriptTransformer;
import org.apache.solr.handler.dataimport.SolrWriter;
import org.apache.solr.handler.dataimport.Transformer;

public class DebugLogger {
    private Stack<DebugInfo> debugStack;
    NamedList output;
    private static final String LINE = "---------------------------------------------";
    private MessageFormat fmt = new MessageFormat("----------- row #{0}-------------");
    boolean enabled = true;

    public DebugLogger() {
        this.output = new NamedList();
        this.debugStack = new Stack<DebugInfo>(){

            @Override
            public DebugInfo pop() {
                if (this.size() == 1) {
                    throw new DataImportHandlerException(500, "Stack is becoming empty");
                }
                return (DebugInfo)super.pop();
            }
        };
        this.debugStack.push(new DebugInfo(null, -1, null));
        this.output = this.debugStack.peek().lst;
    }

    private DebugInfo peekStack() {
        return this.debugStack.isEmpty() ? null : this.debugStack.peek();
    }

    public void log(int event, String name, Object row) {
        if (event == 12) {
            this.enabled = false;
            return;
        }
        if (event == 13) {
            this.enabled = true;
            return;
        }
        if (!this.enabled && event != 1 && event != 2) {
            return;
        }
        if (event == 6) {
            this.debugStack.push(new DebugInfo(null, 6, this.peekStack()));
        } else if (1 == event) {
            this.debugStack.push(new DebugInfo(name, 1, this.peekStack()));
        } else if (8 == event || 5 == event) {
            if (this.debugStack.peek().type == 1 || this.debugStack.peek().type == 6) {
                this.debugStack.peek().lst.add(null, (Object)this.fmt.format(new Object[]{++this.debugStack.peek().rowCount}));
                this.addToNamedList(this.debugStack.peek().lst, row);
                this.debugStack.peek().lst.add(null, (Object)LINE);
            }
        } else if (event == 9) {
            this.popAllTransformers();
        } else if (2 == event) {
            while (this.debugStack.pop().type != 1) {
            }
        } else if (7 == event) {
            while (this.debugStack.pop().type != 6) {
            }
        } else if (event == 10) {
            this.debugStack.push(new DebugInfo(name, event, this.peekStack()));
            this.debugStack.peek().lst.add("EXCEPTION", (Object)DebugLogger.getStacktraceString((Exception)row));
        } else if (3 == event) {
            this.debugStack.push(new DebugInfo(name, event, this.peekStack()));
            this.debugStack.peek().lst.add(null, (Object)LINE);
            this.addToNamedList(this.debugStack.peek().lst, row);
            this.debugStack.peek().lst.add(null, (Object)LINE);
            if (row instanceof DataImportHandlerException) {
                DataImportHandlerException dataImportHandlerException = (DataImportHandlerException)row;
                dataImportHandlerException.debugged = true;
            }
        } else if (4 == event) {
            this.popAllTransformers();
            this.debugStack.peek().lst.add(name, row);
        } else if (11 == event) {
            if (row instanceof DataImportHandlerException) {
                DataImportHandlerException dihe = (DataImportHandlerException)row;
                if (dihe.debugged) {
                    return;
                }
                dihe.debugged = true;
            }
            this.popAllTransformers();
            this.debugStack.peek().lst.add("EXCEPTION", (Object)DebugLogger.getStacktraceString((Exception)row));
        }
    }

    private void popAllTransformers() {
        int type;
        while ((type = this.debugStack.peek().type) != 6 && type != 1) {
            this.debugStack.pop();
        }
    }

    private void addToNamedList(NamedList nl, Object row) {
        block4: {
            block3: {
                if (!(row instanceof List)) break block3;
                List list = (List)row;
                NamedList l = new NamedList();
                nl.add(null, (Object)l);
                for (Object o : list) {
                    Map map = (Map)o;
                    for (Map.Entry entry : map.entrySet()) {
                        nl.add((String)entry.getKey(), entry.getValue());
                    }
                }
                break block4;
            }
            if (!(row instanceof Map)) break block4;
            Map map = (Map)row;
            for (Map.Entry entry : map.entrySet()) {
                nl.add((String)entry.getKey(), entry.getValue());
            }
        }
    }

    static DataSource wrapDs(final DataSource ds) {
        final SolrWriter writer = DocBuilder.INSTANCE.get().writer;
        return new DataSource(){

            public void init(Context context, Properties initProps) {
                ds.init(context, initProps);
            }

            public void close() {
                ds.close();
            }

            public Object getData(String query) {
                writer.log(4, "query", query);
                long start = System.currentTimeMillis();
                try {
                    Object t = ds.getData(query);
                    return t;
                }
                catch (DataImportHandlerException de) {
                    DocBuilder.INSTANCE.get().writer.log(11, null, de);
                    throw de;
                }
                catch (Exception e) {
                    DocBuilder.INSTANCE.get().writer.log(11, null, e);
                    DataImportHandlerException de = new DataImportHandlerException(500, "", e);
                    de.debugged = true;
                    throw de;
                }
                finally {
                    writer.log(4, "time-taken", DocBuilder.getTimeElapsedSince(start));
                }
            }
        };
    }

    static Transformer wrapTransformer(final Transformer t) {
        if (DocBuilder.INSTANCE.get() != null && DocBuilder.INSTANCE.get().verboseDebug) {
            return new Transformer(){

                @Override
                public Object transformRow(Map<String, Object> row, Context context) {
                    DocBuilder.INSTANCE.get().writer.log(5, null, row);
                    String tName = DebugLogger.getTransformerName(t);
                    Object result = null;
                    try {
                        result = t.transformRow(row, context);
                        DocBuilder.INSTANCE.get().writer.log(3, tName, result);
                    }
                    catch (DataImportHandlerException de) {
                        DocBuilder.INSTANCE.get().writer.log(10, tName, de);
                        de.debugged = true;
                        throw de;
                    }
                    catch (Exception e) {
                        DocBuilder.INSTANCE.get().writer.log(10, tName, e);
                        DataImportHandlerException de = new DataImportHandlerException(500, "", e);
                        de.debugged = true;
                        throw de;
                    }
                    return result;
                }
            };
        }
        return t;
    }

    public static String getStacktraceString(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static String getTransformerName(Transformer t) {
        Class<?> transClass = t.getClass();
        if (t instanceof EntityProcessorBase.ReflectionTransformer) {
            return ((EntityProcessorBase.ReflectionTransformer)t).trans;
        }
        if (t instanceof ScriptTransformer) {
            ScriptTransformer scriptTransformer = (ScriptTransformer)t;
            return "script:" + scriptTransformer.getFunctionName();
        }
        if (transClass.getPackage().equals(DebugLogger.class.getPackage())) {
            return transClass.getSimpleName();
        }
        return transClass.getName();
    }

    private static class DebugInfo {
        String name;
        int tCount;
        int rowCount;
        NamedList lst;
        int type;
        DebugInfo parent;

        public DebugInfo(String name, int type, DebugInfo parent) {
            this.name = name;
            this.type = type;
            this.parent = parent;
            this.lst = new NamedList();
            if (parent != null) {
                String displayName = null;
                if (type == 1) {
                    displayName = "entity:" + name;
                } else if (type == 3 || type == 10) {
                    displayName = "transformer:" + name;
                } else if (type == 6) {
                    name = displayName = "document#" + SolrWriter.getDocCount();
                }
                parent.lst.add(displayName, (Object)this.lst);
            }
        }
    }
}

