<?php

$baseDir = dirname( dirname( __FILE__ ) ) ;

$appExists = false;
for( $i=0; $i<8; $i++ ){

	if( $baseDir == "/" )
	{
		break;
	}
	if( file_exists( $baseDir. "/config/global_default.php") )
	{
		$appExists = true;
		break;
	}

	$baseDir = dirname( $baseDir );
}

$baseDir .= "/";

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title>Install</title>
        <script type="text/javascript" src="/~y_zusa/Felie_0_1/public/static/js/libs/jquery.js"></script>

<style type="text/css">
body{

    background-color : #CCCCCC;
}

h3{
    margin : 0px;
}

#main{
    margin : 40px;
    padding: 20px;
    background-color : #CCCCCC;
    border  : 1px #999999 solid;
}

#section{
    margin : 0px 8px 0px 8px;
    background-color : #4b5e9b;
    border  : 1px #666666 solid;
}

#caption{
    margin  : 28px 8px 0px 8px;
    padding : 4px 4px 4px 12px;
    font-size : 24px;
    color : #99806f;
    border : 1px #000000 solid;
    background : #c8f0fd ;
}

#check_ok{
    margin  : 6px;
    padding : 10px;
    border  : 1px #666666 solid;
    background-color :#e1ffcd ;
}

#check_ng{
    margin  : 6px;
    padding : 10px;
    border  : 1px #666666 solid;
    background-color :#ffcdcd ;
}

#check_wn{
    margin  : 6px;
    padding : 10px;
    border  : 1px #666666 solid;
    background-color :#fff994 ;
}

#check_done{
    margin  : 6px;
    padding : 10px;
    border  : 1px #666666 solid;
    background-color :#abc2d2 ;
}

table#dbsetting td{
    width : 220px;
}


</style>

    </head>

<body>

<div id="main">

<?php

$lang = $_POST['lang'];

if( $lang == "" )
{
	$selectableLanguage = array(
	   "en"    => "English",
	   "ja_JP" => "ja ( 日本語 )"
	);

?>
<div id='check_ok'>
    インストールする言語を選択してください。<br />
    Please select application language .<br />
    <form action="" method="POST">
    <select name="lang">
        <?php foreach( $selectableLanguage as $eachLang => $labelLang ) :?>
        <option value="<?php echo $eachLang; ?>"><?php echo $labelLang ;?></option>
        <?php endforeach; ?>
    </select>

    <input type="submit" value="Install Start" />
    </form>


</div>
</div>
<?php

    exit;
}
?>

<?php

$langFile = $baseDir. "data/locales/". $lang. "/install.php" ;
if( file_exists( $baseDir. "data/locales/". $lang. "/install.php" ) )
{
	include $langFile;
}

function out_box( $title, $mesg, $result ){

	echo "<div id='check_". $result. "'>";
    echo "<h3>". $title. "</h3>";
    echo $mesg;

	echo "</div>";
}

function t($mesg){

	global $g_lang;

	if( ! array_key_exists( $mesg, $g_lang ) ) return $mesg;

	return $g_lang[$mesg];
}

if( ! $appExists ){
    out_box( t("Application Not Found!!"), $mesg, false );
}
?>

<?php

if( $_POST['done_install'] != "" )
{
	$dir = dir( $baseDir. "common/install/db" );

    $tableFiles = array();
    while (false !== ($entry = $dir->read())) {

    	if( preg_match( "/\.table/", $entry ) )
    	{
    		$tableFiles[] = $entry;

    	}
    }

    $i = 0;
    $arQuery = array();
    foreach( $tableFiles as $eachFile )
    {
    	$content = file_get_contents( $baseDir. "common/install/db/". $eachFile );
    	$arContent = explode( "\n", $content );

    	foreach( $arContent as $eachLine )
    	{
    		if( trim( $eachLine ) == ";" )
    		{
    			$i++;
    			continue;
    		}

    		$arQuery[$i] .= $eachLine;
    	}
    }

    $conf = array(
            'host'     => $_POST['dbhost'],
            'username' => $_POST['dbuser'],
            'password' => $_POST['dbpass'],
            'dbname'   => $_POST['dbname']
    );

    if( is_numeric( $_POST['dbport']  ) )
    {
    	$conf['port'] = $_POST['dbport'];
    }

    set_include_path( get_include_path(). ":". $baseDir );
    require_once( "Zend/Db/Table.php" );
	require_once( "library/Ext/Db/Adapter/Mysql.php" );
	require_once( "library/Ext/Db/Statement/Mysql.php" );

    $db = Zend_Db::factory( $_POST['dbtype'], $conf );

    $ret = false;
    foreach( $arQuery as $eachQuery )
    {

    	if( $eachQuery == "" ) continue;

    	try{
	    	$ret = $db->query( $eachQuery );
    	}
    	catch( Exception $e ){
    		$failed[] = $e->getMessage();
    		$dbError = true;
    	}

    	if( $ret == false )
    	{
    		$failed[] = "query:". $eachQuery;
    		$dbError = true;
    		break;
    	}
    }

	if( !$dbError ){

        $conf_text  = "<?php\r\n\r\n";
		$conf_text .= "\$g_conf['DB_TYPE'] = '". $_POST['dbtype']. "';\r\n";
		$conf_text .= "\$g_conf['DB_HOST'] = '". $_POST['dbhost']. "';\r\n";
		$conf_text .= "\$g_conf['DB_NAME'] = '". $_POST['dbname']. "';\r\n";
		$conf_text .= "\$g_conf['DB_USER'] = '". $_POST['dbuser']. "';\r\n";
		$conf_text .= "\$g_conf['DB_PASS'] = '". $_POST['dbpass']. "';\r\n\r\n";
		$conf_text .= "\$g_conf['LANGUAGE'] = '". $_POST['lang']. "';\r\n\r\n";
		if( is_numeric( $_POST['dbport'] )  ) $conf_text .= "\$g_conf['DB_PORT'] = '". $_POST['dbport']. "';\r\n";
		$conf_text .= "\$g_conf['INSTALLED'] = true;\r\n";

		file_put_contents( $baseDir. "/config/global.php", $conf_text );

		$modules = apache_get_modules();
		$webHome = dirname($_SERVER['SCRIPT_NAME']). "/";
		$mvcHome = $webHome;
		if( ! in_array( "mod_rewrite", $modules ) ){
            $mvcHome .= "index.php/";
		}

		$conf_text  = "<?php\r\n\r\n";
		$conf_text .= "define( 'APP_BASE_PATH',  '". $baseDir. "' );\r\n";
		$conf_text .= "define( 'WEB_HOME'     ,  '". $webHome. "' );\r\n";
		$conf_text .= "define( 'MVC_HOME'     ,  '". $mvcHome. "' );\r\n";

		file_put_contents( $baseDir. "/config/base_path.php", $conf_text );
?>

<div id="caption"><?php echo t("Install completed!!")?></div>
<div id="section">

	<div id='check_ok'>
	    <h3><?php echo t("Congratulation!! Install Completed!!"); ?></h3>

	    <?php echo t("Default ID and Password is <span style=\"color: red\"> admin / admin </span>. First, you should change password of admin user."); ?>

	    <a href="index.php"><?php echo t("Go to LoginPage"); ?></a><br />

	</div>

</div>

<?php
        //file_put_contents( $baseDir. "/public/install.php", "<?\n" );
        exit;
	}
	else
	{
?>

<div id="caption"><?php echo t("Error was occured")?></div>
<div id="section">

    <div id='check_wn'>
        <h3><?php echo t("Install Failed.. "); ?></h3>

        <?php echo t("Please Check the following errors. After resolve these errors, Click \"Install\" button to retry."); ?>

        <?php
        foreach( $failed as $eachError )
        {
        	out_box( "Error!!", $eachError, "ng" );
        }
        ?>

    </div>
</div>
<?php



	}
}

?>

<div id="caption"><?php echo t("Directory Permission")?></div>
<div id="section">

<?php

////////////////////////////////
// Permission Check
////////////////////////////////

$ng = false;

$def = array();
$def['Template cache directory']["file"] = "smarty/templates_c";
$def['Template cache directory']["ok"] = "OK.";
$def['Template cache directory']["ng"] = t("Template cache directory is not writeable");
$def['Install Script']["file"] = "public/install.php";
$def['Install Script']["ok"] = "OK.";
$def['Install Script']["ng"] = "Install script Can't delete after install";
$def['Configuration']["file"] = "config";
$def['Configuration']["ok"]   = "OK.";
$def['Configuration']["ng"]   = "Configuration directory is not writable";
$def['Basepath Configuration']["file"] = "config/base_path.php";
$def['Basepath Configuration']["ok"]   = "OK.";
$def['Basepath Configuration']["ng"]   = "Base path setting file is not writable";
$def['Config File']["file"] = "config/global.php";
$def['Config File']["ok"]   = "OK.";
$def['Config File']["ng"]   = "Global config file is not writable";

foreach( $def as $title => $eachDef )
{
	if( is_writable( $baseDir. $eachDef['file'] ) ){
		out_box( t($title), $eachDef['ok'] , "ok" );
	}
	else
	{
		out_box( t($title), "(". $eachDef['file']. ")  ". t($eachDef['ng']), "ng" );
		$ng = true;
	}

}

?>

</div>

<div id="caption"><?php echo t("PHP Extension Check")?></div>
<div id="section">
<?php

////////////////////////////////
// Extension Check
////////////////////////////////

$def = array();
$def['Mysql']["file"] = "mysql";
$def['Mysql']["ok"]   = "OK.";
$def['Mysql']["ng"]   = "MySQL Extension is not loaded";
$def['Pdo_Mysql']["file"] = "pdo_mysql";
$def['Pdo_Mysql']["ok"]   = "OK.";
$def['Pdo_Mysql']["ng"]   = "MySQL Extension(PDO) is not loaded";

$dbExtension = false;
foreach( $def as $title => $eachDef )
{
    if( extension_loaded( $eachDef['file'] ) ){
        out_box( t( $title ), $eachDef['ok'] , "ok" );
        $dbExtension[$title] = $eachDef['file'];
    }
    else
    {
        out_box( t( $title ), "(". $eachDef['file']. ")  ". t( $eachDef['ng'] ), "wn" );
    }

}

if( $dbExtension == false ) $ng = true;

?>



<?php

////////////////////////////////
// Appache Extension Check
////////////////////////////////

$modules = apache_get_modules();

$def = array();
$def['mod_rewrite']["file"] = "mod_rewrite";
$def['mod_rewrite']["ok"]   = "OK.";
$def['mod_rewrite']["ng"]   = "mod_rewrite is disabled";

foreach( $def as $title => $eachDef )
{
    if( in_array( $eachDef['file'], $modules ) ){
        out_box( $title, $eachDef['ok'] , "ok" );
    }
    else
    {
        out_box( $title, $eachDef['ng'], "wn" );
    }
}

?>

</div>

<?php

if( ! $ng )
{
?>

<div id="caption"><?php echo t("Database Server")?></div>
<div id="section">

<form action="" method="post" >

<div id="check_ok">

    <table id="dbsetting">
        <tr>
	        <td>
	           <?php echo t( "Database Type"); ?>
	        </td>
	        <td>
	           <select name="dbtype">
	           <?php foreach( $dbExtension as $key => $eachDBType ) :?>
		           <option value="<?php echo $key; ?>"><?php echo $key; ?></option>
	           <?php endforeach ?>
	           </select>
	        </td>
        </tr>
        <tr>
	        <td>
	           <?php echo t("host ( or IP Address )") ;?>
	        </td>
	        <td>
	           <input type="text"  name="dbhost" value="<?php echo ($_POST['dbhost']? $_POST['dbhost'] : "localhost" ) ; ?>" />
	        </td>
        </tr>
        <tr>
	        <td>
	           <?php echo t("dbname") ;?>
	        </td>
	        <td>
	           <input type="text"  name="dbname" value="<?php echo $_POST['dbname'] ; ?>" />
	        </td>
        </tr>
        <tr>
	        <td>
	           <?php echo t("port") ;?>
	        </td>
	        <td>
	           <input type="text"  name="dbport" value="<?php echo ($_POST['dbport']? $_POST['dbport'] : "default" ) ; ?>" />
	        </td>
        </tr>
        <tr>
	        <td>
	           <?php echo t("user name") ;?>
	        </td>
	        <td>
	           <input type="text"  name="dbuser" value="<?php echo $_POST['dbuser'] ; ?>" />
	        </td>
        </tr>
        <tr>
	        <td>
	           <?php echo t("password") ;?>
	        </td>
	        <td>
	           <input type="password"  name="dbpass" value="<?php echo $_POST['dbpass'] ; ?>" />
	        </td>
        </tr>

    </table>
</div>

</div>

<div id="check_done">
    <input type="submit" name="done_install" value="<?php echo t("Install"); ?>" style="width: 240px;"  />

</div>



<?php
}

?>
<input type="hidden" name="lang" value="<?php echo $lang; ?>" />
</form>


</div>

</body>
</html>