<?php

error_reporting(E_ERROR | E_PARSE);

require_once( "../config/base_path.php" );
require_once( "../config/serverinfo.php" );

global $g_conf;
$g_conf = array();
include ( "../config/global_default.php" );
include ( "../config/global.php" );

if( $g_conf[ 'INSTALLED' ] == false ){

    include( "install.php" );
    exit;
}


set_include_path( get_include_path(). ":". APP_BASE_PATH );
set_include_path( get_include_path(). ":". APP_BASE_PATH. "library/Smarty/");

require_once 'Zend/Controller/Front.php';
require_once 'library/Ext/View/Smarty.php';
require_once 'Zend/Controller/Action/Helper/ViewRenderer.php';
require_once 'Zend/Session.php';
require_once 'Zend/Auth.php';
require_once( "Zend/Translate.php" );
require_once( "Zend/Validate/Abstract.php" );

require_once( "library/Ext/Db/Adapter/Mysql.php" );
require_once( "library/Ext/Db/Statement/Mysql.php" );

require_once ( 'library/Ext/Controller/Action.php' );
require_once( "Zend/Db/Table.php" );

require_once( "config/conf_func.php" );


require_once( "common/db/_DBLOADER.php");

include ( "config/global_system.php" );

require_once( "data/locales/locale.php" );

require_once( "common/auth/session.php");
require_once( "common/functions.php");

$translate = new Zend_Translate('array', $g_elang );
Zend_Validate_Abstract::setDefaultTranslator($translate);

//$view は Smartyのラッパー
$view = new Ext_View_Smarty();
$view->setTemplatePath( APP_BASE_PATH. 'common/views' );
$view->setCompilePath ( APP_BASE_PATH. 'smarty/templates_c' );

//$view を使い、.phtml のかわりに .tpl を探すように設定した
// ViewRendererを作成
$viewHelper = new Zend_Controller_Action_Helper_ViewRenderer($view, array('viewSuffix'=>'tpl') );

Zend_Session::start( array( "name" => "AppCode_X902" ) );

$sessionNamespace = new Zend_Session_Namespace( "AppCode_X902", true );
Zend_Registry::set( "sess", $sessionNamespace );

//この ViewRendererを登録
Zend_Controller_Action_HelperBroker::addHelper($viewHelper);
Zend_Controller_Front::run( array(
                                  "default"   =>  APP_BASE_PATH. 'apps/default/controllers',
                                  "auth"      =>  APP_BASE_PATH. 'apps/auth/controllers',
                                  "issue"     =>  APP_BASE_PATH. 'apps/issue/controllers',
                                  "task"      =>  APP_BASE_PATH. 'apps/task/controllers',
                                  "meeting"   =>  APP_BASE_PATH. 'apps/meeting/controllers',
                                  "system"    =>  APP_BASE_PATH. 'apps/system/controllers',
                                  "user"      =>  APP_BASE_PATH. 'apps/user/controllers',
                                  "comment"   =>  APP_BASE_PATH. 'apps/comment/controllers',
                                  "top"       =>  APP_BASE_PATH. 'apps/top/controllers'
                            ) );

?>