<?php

/**
 * @see Zend_View_Interfase
 */
require_once 'Zend/View/Interface.php';
require_once 'Zend/View/Abstract.php';

/**
 * @see Smarty
 */
require_once 'Smarty.class.php';


class Ext_View_Smarty implements Zend_View_Interface

{

    protected $_smarty;
    protected $scriptPath;

    public function __construct($tmplPath = null, $extraParams = array())
    {

        $this->_smarty = new Smarty;

        if (null !== $tmplPath) {

            $this->setScriptPath($tmplPath);

        }



        foreach ($extraParams as $key => $value) {

            $this->_smarty->$key = $value;

        }

    }



    public function getEngine()
    {

        return $this->_smarty;
    }



    public function setScriptPath($path)
    {

        if (is_readable($path)) {

            $this->_smarty->template_dir = $path;

            return;

        }

        throw new Exception('無効なパスが指定されました');

    }



    public function getScriptPath()
    {

        return $this->_smarty->template_dir;
    }



    public function __set($key, $val)

    {

        $this->_smarty->assign($key, $val);

    }



    public function __get($key)
    {

        return $this->_smarty->get_template_vars($key);

    }



    public function __isset($key)
    {

        return (null !== $this->_smarty->get_template_vars($key));

    }



    public function __unset($key)
    {
        $this->_smarty->clear_assign($key);
    }

    protected function htmlescape( $data )
    {
        if (is_array($data) ) {

            $ret = array();
            foreach( $data as $key => $value ){

                if( is_array( $value ) )
                {
                    $data2 = $this->htmlescape( $value );
                    $ret[$key] = $data2;
                }
                else
                {
                    $ret[$key] = htmlspecialchars( $value );
                }
            }
        }
        else
        {
            $ret = htmlspecialchars( $data );
        }

        return $ret;
    }

    public function assign($spec, $value = null)
    {
        if (is_array($spec)) {

            $ary = array();
            foreach( $spec as $key => $val ){
                $this->assign( $key, $val );
            }

            return;
        }

        $this->_smarty->assign( $spec, $this->htmlescape( $value ));
    }

    /**
     *
     */
    public function assignLang($spec, $value = null, $params=null)
    {

        $this->assign( $spec, t( $value, $params ) );
    }

    /**
     *
     */
    public function assignRequest( $request ){

        $this->assign( "d", $request );
    }

    public function assignByRef(&$spec, &$value = null)
    {

        if (is_array($spec)) {

            $this->_smarty->assign_by_ref($spec);
            return;
        }

        $this->_smarty->assign_by_ref($spec, $value);
    }



    public function clearVars()
    {

        $this->_smarty->clear_all_assign();

    }



    public function render($name)
    {

        return $this->_smarty->fetch( $this->scriptPath. "/scripts/". $name );

    }

    public function setTemplatePath( $path ){

        $this->_smarty->template_dir = $path;
    }

    /**
     *
     */
    public function setCompilePath($path)
    {
        if (is_dir($path)) {
            $this->_smarty->compile_dir = $path;
            return true;
        }
        return false;
    }


    public function getScriptPaths()
    {

        return array($this->_smarty->template_dir);

    }



    public function setBasePath($path, $classPrefix = 'Zend_View')
    {

    }



    public function addBasePath($string, $classPrefix = 'Zend_View')
    {
        $this->scriptPath = $string;
    }

}

