<?php

class Ext_Form extends Zend_Form {

	protected $errorExist = false;
    protected $_errors;

	public function init(){

        foreach ($this->_elements as $name => $element )
        {

        	$this->_elements[$name]->clearDecorators();

        	$this->_elements[$name]->addDecorator('ViewHelper')
                    ->addDecorator('Errors')
                    ->addDecorator('Description', array('tag' => 'p', 'class' => 'description'));
//                    ->addDecorator('HtmlTag', array('tag' => 'dd',
//                                                             'id'  => $this->getName() . '-element'))
//                    ->addDecorator('Label', array('tag' => 'dt'));

        }
	}

	public function keepValue( Array $request ){

		$res = true;

		foreach ($this->_elements as $name => $element )
		{
			if( ! array_key_exists( $name, $request ) ) continue;

			$this->_elements[$name]->setValue( $request[ $name ] );
        }

        return $res;

	}

	public function editComplete(){

		foreach ($this->_elements as $name => $element )
        {
        	$this->_elements[$name]->clearDecorators();

            $this->_elements[$name]->addDecorator('HtmlTag', array('tag' => 'dd',
                                                             'id'  => $this->getName() . '-element'))
                    ->addDecorator('Description', array('tag' => 'p', 'class' => 'description') );
//                    ->addDecorator('HtmlTag', array('tag' => 'dd',
//                                                             'id'  => $this->getName() . '-element'))
//                    ->addDecorator('Label', array('tag' => 'dt'));
        }

	}

	public function validateAll( Ext_Controller_Action $c, Array $p, Array $req ){

		$errors = array();

		foreach( $p as $idx => $name )
		{
			$value = $req[$name];

			$res1 = $c->extValidate( $name, $value, $c->getRequest()->getActionName(), $req );
			if( is_null( $res1 ) ) $res1 = true;

			if( $c->shouldSkip( $res1 ) ) continue;

			$elem = $this->getElement( $name );

			if( empty( $elem ) ) continue;

			$res2 = $elem->isValid( $value  ) && ( $res1 === true ) ;
			if( $res2 !== true )
			{
				$this->errorExist = true;

				$arErrors = $elem->getErrors();
				$validators = $elem->getValidators();
				foreach( $validators as $eachValidator )
				{
					$messageTemplate[] = $eachValidator->getMessageTemplates();
				}

				$eMessage = $elem->getMessages( $name ) ;
				foreach( $eMessage as $eachMesg )
				{
					$errors[ $name ] .= t( $eachMesg ). ".";
				}

				if( is_array( $res1 ) )
				{
					foreach( $res1 as $eachError )
					{
						$errors[ $name ] .= t( $eachError ). ".";
					}
				}
			}
		}

		$this->_errors = $errors;
		$c->view->assign( "e", $errors );
	}

	public function errorExist(){

		return $this->errorExist;
	}

	public function getErrors(){
		return $this->_errors;
	}

}

?>