<?php

class Ext_Db_Table extends Zend_Db_Table {


	 /**
     * Inserts a new row.
     *
     * @param  array  $data  Column-value pairs.
     * @return mixed         The primary key of the row inserted.
     */
    public function insert(array $data)
    {

    	if( ! array_key_exists( 'insert_time', $data ) )
        {
            $data['insert_time'] = db_common_now( $db );
        }

        if( $data['insert_time'] === null )
        {
            unset( $data['insert_time'] );
        }

        if( ! array_key_exists( 'insert_user', $data ) )
        {
            $data['insert_user'] = usess_get_userid();
        }

        if( $data['insert_user'] === null )
        {
            unset( $data['insert_user'] );
        }

        if( ! array_key_exists( 'update_time', $data ) )
        {
            $data['update_time'] = db_common_now( $db );
        }

        if( $data['update_time'] === null )
        {
            unset( $data['update_time'] );
        }

        if( ! array_key_exists( 'update_user', $data ) )
        {
            $data['update_user'] = usess_get_userid();
        }

        if( $data['update_user'] === null )
        {
            unset( $data['update_user'] );
        }

    	return parent::insert( $data );
    }


    /**
     * Updates existing rows.
     *
     * @param  array        $data  Column-value pairs.
     * @param  array|string $where An SQL WHERE clause, or an array of SQL WHERE clauses.
     * @return int          The number of rows updated.
     */
    public function update(array $data, $where )
    {

    	if( ! array_key_exists( 'update_time', $data ) )
    	{
	    	$data['update_time'] = db_common_now( $db );
    	}

    	if( $data['update_time'] === null )
    	{
    		unset( $data['update_time'] );
    	}

    	if( ! array_key_exists( 'update_user', $data ) )
        {
            $data['update_user'] = usess_get_userid(false);
        }

        if( $data['update_user'] === null )
        {
            unset( $data['update_user'] );
        }

    	return parent::update( $data, $where );
    }


}