<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Db
 * @subpackage Statement
 * @copyright  Copyright (c) 2005-2008 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id: Mysqli.php 9738 2008-06-19 23:06:36Z peptolab $
 */


/**
 * @see Zend_Db_Statement
 */
require_once 'Zend/Db/Statement.php';


/**
 * Extends for Mysqli
 *
 * @category   Zend
 * @package    Zend_Db
 * @subpackage Statement
 * @copyright  Copyright (c) 2005-2008 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 */
class Zend_Db_Statement_Mysql extends Zend_Db_Statement
{

    /**
     * The mysqli_stmt object.
     *
     * @var mysqli_stmt
     */
    protected $_stmt;

    protected $queryString ;

    protected $_result;

    /**
     * Column names.
     *
     * @var array
     */
    protected $_keys;

    /**
     * Fetched result values.
     *
     * @var array
     */
    protected $_values;

    /**
     * @var array
     */
    protected $_meta = null;

    /**
     * @param  string $sql
     * @return void
     * @throws Zend_Db_Statement_Mysqli_Exception
     */
    public function _prepare($sql)
    {
        $this->_stmt = $this->_adapter->getConnection();

        if ($this->_stmt === false ) {
            /**
             * @see Zend_Db_Statement_Mysqli_Exception
             */
            require_once 'Mysql/Exception.php';
            throw new Zend_Db_Statement_Mysql_Exception("Mysqli prepare error: " . $mysqli->error);
        }

        $this->queryString = $sql;
    }

    /**
     * Binds a parameter to the specified variable name.
     *
     * @param mixed $parameter Name the parameter, either integer or string.
     * @param mixed $variable  Reference to PHP variable containing the value.
     * @param mixed $type      OPTIONAL Datatype of SQL parameter.
     * @param mixed $length    OPTIONAL Length of SQL parameter.
     * @param mixed $options   OPTIONAL Other options.
     * @return bool
     * @throws Zend_Db_Statement_Mysqli_Exception
     */
    protected function _bindParam($parameter, &$variable, $type = null, $length = null, $options = null)
    {
        return true;
    }

    /**
     * Closes the cursor and the statement.
     *
     * @return bool
     */
    public function close()
    {
        if ($this->_stmt) {
        	$r = mysql_close( $this->_stmt );
            $this->_stmt = null;
            return $r;
        }
        return false;
    }

    /**
     * Closes the cursor, allowing the statement to be executed again.
     *
     * @return bool
     */
    public function closeCursor()
    {
//        if ($stmt = $this->_stmt) {
//            $mysqli = $this->_adapter->getConnection();
//            while ($mysqli->next_result()) {}
//            $this->_stmt->free_result();
//            return $this->_stmt->reset();
//        }
        return false;
    }

    /**
     * Returns the number of columns in the result set.
     * Returns null if the statement has no result set metadata.
     *
     * @return int The number of columns.
     */
    public function columnCount()
    {
        if ( $this->_result ) {
            return mysql_num_fields( $this->_result );
        }
        return 0;
    }

    /**
     * Retrieves the error code, if any, associated with the last operation on
     * the statement handle.
     *
     * @return string error code.
     */
    public function errorCode()
    {
        if (!$this->_stmt) {
            return false;
        }
        return @mysql_errno($this->_stmt);
    }

    /**
     * Retrieves an array of error information, if any, associated with the
     * last operation on the statement handle.
     *
     * @return array
     */
    public function errorInfo()
    {
        if (!$this->_stmt) {
            return false;
        }
        return array(
            @mysql_error($this->_stmt),
            @mysql_errno($this->_stmt),
            @mysql_error($this->_stmt),
        );
    }

    /**
     * Executes a prepared statement.
     *
     * @param array $params OPTIONAL Values to bind to parameter placeholders.
     * @return bool
     * @throws Zend_Db_Statement_Mysqli_Exception
     */
    public function _execute(array $params = null)
    {
        if (!$this->_stmt) {
            return false;
        }

        // if no params were given as an argument to execute(),
        // then default to the _bindParam array
        if ($params === null) {
            $params = $this->_bindParam;
        }

        // send $params as input parameters to the statement
        if ($params) {
//            array_unshift($params, str_repeat('s', count($params)));

        	foreach( $params as $key => $val )
        	{
        		$params[$key] = $this->_adapter->_quote( $val );
        	}

        	$this->queryString = str_replace( "%s", ";(s);", $this->queryString );
        	$this->queryString = str_replace( "?", "%s", $this->queryString );
        	$this->queryString = vsprintf( $this->queryString, $params );
        	$this->queryString = str_replace( ";(s);", "%s", $this->queryString );

//            var_dump( $params );
//            call_user_func_array(
//                array($this->_stmt, 'bind_param'),
//                $params
//            );
        }

        // execute the statement
        $retval = @mysql_query($this->queryString, $this->_stmt );
        if ($retval === false) {
            /**
             * @see Zend_Db_Statement_Mysqli_Exception
             */
            require_once 'Mysql/Exception.php';
            throw new Zend_Db_Statement_Mysql_Exception("Mysql statement execute error : " . @mysql_error($this->_stmt));
        }

        $this->_result = $retval;

        // retain metadata
//        if ($this->_meta === null) {
//            $this->_meta = $this->_stmt->result_metadata();
//            if ($this->_stmt->errno) {
//                /**
//                 * @see Zend_Db_Statement_Mysqli_Exception
//                 */
//                require_once 'Zend/Db/Statement/Mysqli/Exception.php';
//                throw new Zend_Db_Statement_Mysqli_Exception("Mysqli statement metadata error: " . $this->_stmt->error);
//            }
//        }

        // statements that have no result set do not return metadata
//        if ($this->_meta !== false) {
//
//            // get the column names that will result
//            $this->_keys = array();
//            foreach ($this->_meta->fetch_fields() as $col) {
//                $this->_keys[] = $this->_adapter->foldCase($col->name);
//            }
//
//            // set up a binding space for result variables
//            $this->_values = array_fill(0, count($this->_keys), null);
//
//            // set up references to the result binding space.
//            // just passing $this->_values in the call_user_func_array()
//            // below won't work, you need references.
//            $refs = array();
//            foreach ($this->_values as $i => &$f) {
//                $refs[$i] = &$f;
//            }
//
//            $this->_stmt->store_result();
//            // bind to the result variables
//            call_user_func_array(
//                array($this->_stmt, 'bind_result'),
//                $this->_values
//            );
//        }
        return $retval;
    }


    /**
     * Fetches a row from the result set.
     *
     * @param int $style  OPTIONAL Fetch mode for this fetch operation.
     * @param int $cursor OPTIONAL Absolute, relative, or other.
     * @param int $offset OPTIONAL Number for absolute or relative cursors.
     * @return mixed Array, object, or scalar depending on fetch mode.
     * @throws Zend_Db_Statement_Mysqli_Exception
     */
    public function fetch($style = null, $cursor = null, $offset = null)
    {
        if (!$this->_stmt) {
            return false;
        }
        // fetch the next result

//        switch ($retval) {
//        case null: // end of data
//        case false: // error occurred
////            $this->_stmt->reset();
//            return false;
//        default:
            // fallthrough
//        }

        // make sure we have a fetch mode
//        if ($style === null) {
//            $style = $this->_fetchMode;
//        }

        // dereference the result values, otherwise things like fetchAll()
        // return the same values for every entry (because of the reference).
//        $values = array();
//        foreach ($this->_values as $key => $val) {
//            $values[] = $val;
//        }

        $row = false;
        switch ($style) {
            case Zend_Db::FETCH_NUM:
                $row = mysql_fetch_row($this->_result);
                break;
            default:
            case Zend_Db::FETCH_ASSOC:
            	$row = mysql_fetch_assoc($this->_result);
//                $row = array_combine($this->_keys, $values);
                break;
            case Zend_Db::FETCH_BOTH:
            	$row = mysql_fetch_array($this->_result);
                break;
            case Zend_Db::FETCH_OBJ:
                $row = mysql_fetch_object($this->_result);
                break;
            case Zend_Db::FETCH_BOUND:
                $row = mysql_fetch_array($this->_result);
                return $this->_fetchBound($row);
                break;
                /**
                 * @see Zend_Db_Statement_Mysqli_Exception
                 */
                require_once 'Mysql/Exception.php';
                throw new Zend_Db_Statement_Mysql_Exception("Invalid fetch mode '$style' specified");
                break;
        }
        return $row;
    }

    /**
     * Retrieves the next rowset (result set) for a SQL statement that has
     * multiple result sets.  An example is a stored procedure that returns
     * the results of multiple queries.
     *
     * @return bool
     * @throws Zend_Db_Statement_Mysqli_Exception
     */
    public function nextRowset()
    {
        /**
         * @see Zend_Db_Statement_Mysqli_Exception
         */
        require_once 'Mysql/Exception.php';
        throw new Zend_Db_Statement_Mysql_Exception(__FUNCTION__.'() is not implemented');
    }

    /**
     * Returns the number of rows affected by the execution of the
     * last INSERT, DELETE, or UPDATE statement executed by this
     * statement object.
     *
     * @return int     The number of rows affected.
     */
    public function rowCount()
    {
        if (!$this->_adapter || !$this->_stmt) {
            return false;
        }
        return mysql_affected_rows( $this->_stmt );
    }

}