<?php

require_once( "library/Ext/Exception/base/ExtApplicationException.php" );
require_once( "library/Ext/Exception/ExtInvalidInputException.php" );
require_once( "library/Ext/Log/exLog.php" );

require_once( "common/db/project.php" );

class Ext_Controller_Action extends Zend_Controller_Action{

	protected $public = false;
	private $errorForward = false;

	/**
	 *
	 * @param Zend_Controller_Request_Abstract $request
	 * @param Zend_Controller_Response_Abstract $response
	 * @param array $invokeArgs
	 * @return unknown_type
	 */
	public function __construct(Zend_Controller_Request_Abstract $request, Zend_Controller_Response_Abstract $response, array $invokeArgs = array())
    {

    	$mod = $request->getModuleName();
    	$ctl = $request->getControllerName();
    	$act = $request->getActionName();

//    	echo $mod. "<br />";
//    	echo $ctl. "<br />";
//    	echo $act. "<br />";

    	parent::__construct( $request, $response, $invokeArgs );
    	$this->init2();
    	$this->appinit();
    }

    /**
     *
     * @return void
     */
    final private function init2(){

        $projects = db_project_menu();

        $app = array();
        $app['projects'] = $projects;
        $app['selected_project'] = usess_selected_project( $this->getRequest()->getParam( "selected_project", null ) );

        $this->view->assign( "app", $app );

        $this->view->assign( "HTTP_HOST", $_SERVER['HTTP_HOST'] );
        $this->view->assign( "WEB_STATIC_HOME", WEB_HOME );
        $this->view->assign( "WEB_HOME", MVC_HOME );

        $this->view->assign( "usess_userid", usess_get_userid( false ) );
    }

    /**
     *
     */
    protected function appinit(){}

    /**
     * Dispatch the requested action
     * Change to Exception model
     * @param string $action Method name of action
     * @return void
     */
    public function dispatch($action)
    {
        // Notify helpers of action preDispatch state
        $this->_helper->notifyPreDispatch();

        $this->preDispatch();
        if ($this->getRequest()->isDispatched()) {
            if (null === $this->_classMethods) {
                $this->_classMethods = get_class_methods($this);
            }
            // preDispatch() didn't change the action, so we can continue
            if ($this->getInvokeArg('useCaseSensitiveActions') || in_array($action, $this->_classMethods)) {
                if ($this->getInvokeArg('useCaseSensitiveActions')) {
                    trigger_error('Using case sensitive actions without word separators is deprecated; please do not rely on this "feature"');
                }
                try{
	                $this->$action();
                } catch( ExtInvalidInputException $e ){
                	$this->_forward( $e->getNextAction() );
                } catch( ExtApplicationException $e ){
                	echo $e->getMessage();
                } catch( Exception $e ){
                	echo $e->getMessage();
                	$this->_forward( "index", "error", "default" );
                }
            } else {
                $this->__call($action, array());
            }
            $this->postDispatch();
        }

        // whats actually important here is that this action controller is
        // shutting down, regardless of dispatching; notify the helpers of this
        // state
        $this->_helper->notifyPostDispatch();
    }

    public function extValidate( $name, $value, $action, $request )
    {
    }

    public function shouldSkip( $val ){

    	if( $val === "skip" ) return true;

    	return false;
    }

    public function isNotLogin(){

    	if( $this->public ) return false;

    	if( session_is_login() ) return false;

    	$this->_redirect( "/" );
    	return true;
    }

    public function isNotAdmin(){

        if( session_is_admin() ) return false;

        return true;
    }

    public function isNotSelectProject(){

        if( usess_selected_project() != "" ) return false;

//        $this->_forward( "loginederror", "index", "default", array( "message", t( "Project not selected" ) )  );
        $this->_redirect( "default/index/loginederror?type=project_not_select" );

        return true;
    }



}
?>