<?php
require_once( conf_lang(). "/".conf_lang(). ".php" );
require_once( conf_lang(). "/errors.php" );

$g_lang = array_merge( $g_lang, $g_elang );

//require_once( "en_US/en_US.php" );

function t( $key, $params=null ){

	global $g_lang;

	$s = ! array_key_exists( $key, $g_lang ) ? $key : $g_lang[$key];

	if( is_array( $params ) )
	{
		return vsprintf( $s, $params );
	}
	else if( $params !== null )
	{
		if( $params == "" ) return "";
		return sprintf( $s, $params );
	}

	return $s;
}

function dateselect( $name, $y="", $m="", $d="" ){

	$sY = date("Y") - 1;
	$eY = date("Y") + 10;

	$Y = array( ""=>" " );
	for( $i=date("Y")-1; $i<=date("Y")+10; $i++ ){ $Y[$i]=$i; }

	$M = array( ""=>" " );
	for( $i=1; $i<=12; $i++ ){ $M[$i]=$i; }

	$D = array( ""=>" ");
	for( $i=1; $i<=31; $i++ ){ $D[$i]=$i; }

	$s = "<select name='". $name. "[Y]' class='selectY' >";

	foreach( $Y as $val => $label )
	{
		$s .= "<option value='". $val. "' ". ( $val==$y? "selected": "" ) .">". $label. "</option>";
	}

	$s .= "</select>";

	$s .= "<select name='". $name. "[M]' class='selectM' >";

	foreach( $M as $val => $label )
	{
		$s .= "<option value='". $val. "' ". ( $val==$m? "selected": "" ) .">". $label. "</option>";
	}

	$s .= "</select>";

	$s .= "<select name='". $name. "[D]' class='selectD' >";

	foreach( $D as $val => $label )
	{
		$s .= "<option value='". $val. "' ". ( $val==$d? "selected": "" ) .">". $label. "</option>";
	}

	$s .= "</select>";

	return $s;

}

function timeselect( $name, $h="", $m="" ){

    $H = array( ""=>" " );
    for( $i=0; $i<=23; $i++ ){ $H[$i]=$i; }

    $I = array( ""=>" ");
    for( $i=0; $i<=50; $i+=10 ){ $I[$i]=$i; }

    $s = "<select name='". $name. "[H]' class='selectH' >";

    foreach( $H as $val => $label )
    {
        $s .= "<option value='". $val. "' ". ( $val==$h? "selected": "" ) .">". $label. "</option>";
    }

    $s .= "</select>";

    $s .= "<select name='". $name. "[I]' class='selectI' >";

    foreach( $I as $val => $label )
    {
        $s .= "<option value='". $val. "' ". ( $val==$m? "selected": "" ) .">". $label. "</option>";
    }

    $s .= "</select>";

    return $s;

}

function datearray( $str="", $array ){

	if( ! is_array( $array ) ) return null;
	if( empty( $array["Y"] ) || empty( $array["M"] ) || empty( $array["D"] ) ) return null;

	$fmt = "%Y/%M/%D";

	$str = str_replace( "%Y", $array["Y"], $fmt );
	$str = str_replace( "%M", $array["M"], $str );
	$str = str_replace( "%D", $array["D"], $str );

	return $str;

}

function timearray( $str="", $array, $default=null ){

	if( ! is_array( $array ) ) return null;
	if( empty( $array["H"] ) && empty( $array["I"] )  ) return t($default);

	$fmt = "%H:%I";

	$str = str_replace( "%H", $array["H"], $fmt );
	$str = str_replace( "%I", $array["I"] == 0 ? "00": $array["I"] , $str );

	return $str;

}

function datehidden( $name , $array ){

	$str = "";

    $str .= "<input type=\"hidden\" name=\"". $name. "[Y]\" value=\"". $array["Y"]. "\" />" ;
    $str .= "<input type=\"hidden\" name=\"". $name. "[M]\" value=\"". $array["M"]. "\" />" ;
    $str .= "<input type=\"hidden\" name=\"". $name. "[D]\" value=\"". $array["D"]. "\" />" ;

    return $str;

}

function timehidden( $name , $array ){

	$str = "";

    $str .= "<input type=\"hidden\" name=\"". $name. "[H]\" value=\"". $array["H"]. "\" />" ;
    $str .= "<input type=\"hidden\" name=\"". $name. "[I]\" value=\"". $array["I"]. "\" />" ;

    return $str;

}

function hiddenarray( $name, $array ){

	$str = "";

	if( !is_array( $array ) ) return null;

	foreach( $array as $key => $eachParam )
	{
		$str .= "<input type=\"hidden\" name=\"". $name. "[". $key. "]\" value=\"". $eachParam. "\" />" ;
	}

	return $str;

}