<?php

require_once( "common/db/phenomenontypes.php" );

function mst_phenomenon_types(){

	$ret = array();
	$phenom = db_phenomenontypes_list();

	foreach( $phenom as $eachPhenom )
	{
		$ret[$eachPhenom['id']] = $eachPhenom['name'];
	}

    return $ret;
}

function mst_priority(){

	$ret = array();
	$ret[700] = t("priority high");
//	$ret[600] = t("priority mid-high");
	$ret[500] = t("priority middle");
//	$ret[400] = t("priority mid-low");
	$ret[300] = t("priority low");

	return $ret;
}

function mst_severity(){

	$ret = array();
	$ret[1000] = t("severity very-high");
	$ret[700]  = t("severity high");
//	$ret[600]  = t("severity mid-high");
	$ret[500]  = t("severity middle");
	$ret[400]  = t("severity mid-low");
//	$ret[300]  = t("severity low");
	$ret[100]  = t("severity very-low");

	return $ret;
}

function mst_scale(){

    $ret = array();
    $ret[700] = t("scale large");
    $ret[500] = t("scale middle");
    $ret[300] = t("scale small");
    $ret[200] = t("scale very-small");

    return $ret;
}

function mst_users( $onlyEnabled=true ){

	require_once( "common/db/user.php" );

	$paginator = db_user_list( $onlyEnabled );
	$paginator->setCurrentPageNumber( 1 );
	$paginator->setItemCountPerPage( 10000 );

	$arItem = (array) $paginator->getCurrentItems();

	$arUsers = array();
	foreach( $arItem as $eachUser )
	{
        $arUsers[$eachUser['id'] ] = $eachUser['realname'];
	}

	return $arUsers;
}

function mst_issue_status(){

	$ret = array();
    $ret[1100] = t("New Arrival");
//    $ret[1200] = t("Planning");
    $ret[1300] = t("In Progress");
    $ret[1400] = t("Finished");
    $ret[1500] = t("Approved");
//    $ret[1900] = t("Treminated");

    return $ret;
}

function mst_task_status(){

	$ret = array();
    $ret[1100] = t("not begin");
    $ret[1300] = t("in progress");
    $ret[1500] = t("finished");
    $ret[1900] = t("halted");
    $ret[1950] = t("break");

    return $ret;
}

function mst_categories(){

	$rows = db_categories_list( usess_selected_project() );

	$ret = array();
	foreach( $rows as $eachRow )
	{
		$ret[ $eachRow['id'] ] = $eachRow['name'];
	}

	return $ret;
}




