<?php

function date_explode( $dateString=null ){

	if( $dateString === null ) $dateString = date( "Y-m-d 00:00:00" );

	$arDate = array();
	$arDate["Y"] = date( "Y", strtotime( $dateString ) );
	$arDate["M"] = date( "m", strtotime( $dateString ) );
	$arDate["D"] = date( "d", strtotime( $dateString ) );

	return $arDate;

}

/**
 *
 * @param timestamp $time
 * @return timestamp
 */
function firstday_of_week( $time=null ){

	if( $time === null ) $time = time();
	return strtotime( ( date("N", $time ) - 1 ) . "days ago", $time );
}

function cal_weeks( $startTS, $term = 3 ){

	$ret = array();
	for( $i=0; $i < $term*7; $i++ )
	{
		$d = strtotime( $i. "days" , $startTS );
		$ret[ $d ] = $d;
	}

	return $ret;
}