<?php

function db_user_all_cnt( $onlyEnabled=true ){

	$db = DBLOADER::getApp();

	$select = $db->select();

	$select->from(array('u'=>'members'),
	array('cnt'=>new Zend_Db_Expr('COUNT(*)')));
	if( $onlyEnabled )
	{
		$where = $db->quoteInto('u.enabled=?', '1');
		$select->where($where);
	}

	$stmt = $db->query( $select );
	$result = $stmt->fetch();

	return $result["cnt"];
}

/**
 *
 * @param $onlyEnabled
 * @return Zend_Paginator
 */
function db_user_list( $onlyEnabled=true ){

	$db = DBLOADER::getApp();

	$select = $db->select();

	$select->from( array( "u"=>"members" ) );
	if( $onlyEnabled ) $select->where($db->quoteInto( 'u.enabled=?', 1 ));

	return Zend_Paginator::factory( $select );

//	$stmt = $db->query( $select);
//	$result = $stmt->fetchAll();
//	return $result;
}

function db_user_one( $uid ){

	if( $uid == "") throw new Exception();

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "u"=>"members" ) );
    $select->where($db->quoteInto( 'u.id=?', $uid ) );

    $stmt = $db->query( $select );
    $result = $stmt->fetch();
    return $result;
}


function db_user_isduplicate( $username, $uid ){

	$db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "u"=>"members" ) );
    if( $uid == "" )
    {
	    $select->where($db->quoteInto( 'u.enabled=?', 1 ) );
	    $select->where($db->quoteInto( 'u.username=?', $username ) );
    }
    else
    {
	    $select->where($db->quoteInto( 'u.enabled=?', 1 ) );
	    $select->where($db->quoteInto( 'u.username=?', $username ) );
	    $select->where($db->quoteInto( 'u.id<>?', $uid ) );
    }

    $stmt = $db->query( $select );
    $result = $stmt->fetchAll();

    if( count( $result ) > 0 ) return true;

    return false;

}

function db_user_repassword( $uid, $ticket ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "u"=>"members" ) );

    $select->where($db->quoteInto( 'u.id=?', $uid ) );
    $select->where($db->quoteInto( 'u.pwremind_ticket=?', $ticket ) );

    $stmt = $db->query( $select );
    $result = $stmt->fetchAll();

    if( count( $result ) > 0 ) return true;

    return false;

}

