<?php

function db_task_list( $issue_id ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "t"=>"tasks" ) );
    $select->where($db->quoteInto( 't.issue_id=?', $issue_id ));

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    return $result;
}

function db_task_search( $param ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "t"=>"tasks" ), array("t.*", "issue_title"=>"i.title") );
    $select->join( array( "i"=>"issues"), "t.issue_id = i.id", array() );

    if( $param['handleuser'] != "" )
    {
    	$issuePaginator = db_issues_list_mine( usess_selected_project(), null, $param['handleuser'] );
    }
    else
    {
	    $issuePaginator = db_issues_list( usess_selected_project() );
    }

    $issuePaginator->setItemCountPerPage( 10000 );
    $arIssues = $issuePaginator->getCurrentItems();
    $arId[-1] = -1 ;
    foreach( $arIssues as $eachIssue )
    {
    	$arId[ $eachIssue['id'] ] = $eachIssue['id'];
    }

    $select->where('t.issue_id IN ( '. implode( ",", $arId). ')' );

    if( $param['status'] ) $select->where( $db->quoteInto( 't.status=?', $param['status'] ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    return $result;
}

function db_task_search_mine( $param=array(), $uid=null ){

//	if( empty( $uid ) )
//	{
//		$uid = usess_get_userid();
//	}
	$param['handleuser'] = $uid;

	return db_task_search( $param );

}

function db_tasks_finish_all( $issue_id ){

	$db = DBLOADER::getApp();
	$tasks = db_task_list( $issue_id );

	$taskTable = new Ext_Db_Table( array( "name"=>"tasks", "db"=>$db ) );
	$data = array(
            'status'            => 1500,
            'progress'          => 100
	);

	foreach( $tasks as $eachTask )
	{

		$where = $taskTable->getAdapter()->quoteInto('id=?', $eachTask['id'] );
		$taskTable->update( $data, $where );
	}

	return true;
}