<?php

function db_summary_issues_priority( $project_id = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ), array("priority", "status", "cnt" => "COUNT(*)" ) );
    $select->where($db->quoteInto( 'i.status < ?', 1900 ));
    if( $project_id ) $select->where($db->quoteInto( 'i.project_id = ?', $project_id ));
    $select->group( array( "priority", "status" ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $ret = array();

    foreach( $result as $eachRow ){

    	$ret[ $eachRow['priority'] ][ $eachRow['status'] ] = $eachRow['cnt'];
    }

    return $ret;
}

function db_summary_issues_priority2( $project_id = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ), array("status", "priority", "cnt" => "COUNT(*)" ) );
    $select->where($db->quoteInto( 'i.status < ?', 1900 ));
    if( $project_id ) $select->where($db->quoteInto( 'i.project_id = ?', $project_id ));
    $select->group( array( "status", "priority" ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $ret = array();

    foreach( mst_issue_status() as $eachStatus => $txt){

    	foreach( mst_priority() as $eachPriority => $txt2 )
    	{
    		$ret[ $eachStatus ][ $eachPriority ] = 0;
    	}

    }

    foreach( $result as $eachRow ){

        $ret[ $eachRow['status'] ][ $eachRow['priority'] ] = $eachRow['cnt'];
    }

    return $ret;
}

function db_summary_issues_scale( $project_id = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ), array("status", "scale", "cnt" => "COUNT(*)" ) );
    $select->where($db->quoteInto( 'i.status < ?', 1900 ));
    if( $project_id ) $select->where($db->quoteInto( 'i.project_id = ?', $project_id ));
    $select->group( array( "status", "scale" ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $ret = array();

    foreach( $result as $eachRow ){

        $ret[ $eachRow['status'] ][ $eachRow['scale'] ] = $eachRow['cnt'];
    }

    return $ret;
}

function db_summary_issues_severity( $project_id = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ), array( "severity", "status", "cnt" => "COUNT(*)" ) );
    $select->where($db->quoteInto( 'i.status < ?', 1900 ));
    if( $project_id ) $select->where($db->quoteInto( 'i.project_id = ?', $project_id ));
    $select->group( array( "severity", "status" ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $ret = array();

    foreach( $result as $eachRow ){

    	$ret[ $eachRow['severity'] ][ $eachRow['status'] ] = $eachRow['cnt'];
    }

    return $ret;
}

function db_summary_issues_status_total( $project_id = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ), array("status", "cnt" => "COUNT(*)" ) );
    $select->where($db->quoteInto( 'i.status < ?', 1900 ));
    if( $project_id ) $select->where($db->quoteInto( 'i.project_id = ?', $project_id ));
    $select->group( array( "status" ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $ret = array();

    foreach( $result as $eachRow ){

    	$ret[ $eachRow['status'] ] = $eachRow['cnt'];
    }

    return $ret;
}

/* ------------------------------------
 *  for Task
 -------------------------------------- */

function db_summary_tasks_status_total( $project_id = null, $param=array() ){

    $db = DBLOADER::getApp();

    $select = $db->select();
    $select->from( array( "t"=>"tasks" ), array("status", "cnt" => "COUNT(*)" ) );

    if( $param['handleuser'] != "" )
    {
        $issuePaginator = db_issues_list_mine( usess_selected_project(), null, $param['handleuser'] );
    }
    else
    {
        $issuePaginator = db_issues_list( usess_selected_project() );
    }

    $issuePaginator->setItemCountPerPage( 10000 );
    $arIssues = $issuePaginator->getCurrentItems();
    $arId[-1] = -1 ;
    foreach( $arIssues as $eachIssue )
    {
        $arId[ $eachIssue['id'] ] = $eachIssue['id'];
    }

    $select->where('t.issue_id IN ( '. implode( ",", $arId). ')' );

//    $select->where($db->quoteInto( 'i.status < ?', 1900 ));
//    if( $project_id ) $select->where($db->quoteInto( 't.project_id = ?', $project_id ));
    $select->group( array( "status" ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $ret = array();

    foreach( $result as $eachRow ){

        $ret[ $eachRow['status'] ] = $eachRow['cnt'];
    }

    return $ret;
}

function db_summary_tasks_status_total_mine( $project_id = null, $param=array(), $uid=null ){

    $param['handleuser'] = $uid;

    return db_summary_tasks_status_total( $project_id, $param );

}