<?php


function db_project_menu( $onlyEnabled=true ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "p"=>"project" ) );
    if( $onlyEnabled ) $select->where($db->quoteInto( 'p.enabled=?', 1 ));

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $ret = array();
    foreach( $result as $eachProject )
    {
    	$ret[$eachProject['id'] ] = $eachProject['name'];
    }

    return $ret;
}

/**
 *
 * @param $onlyEnabled
 * @return Zend_Paginator
 */
function db_project_list( $onlyEnabled=true ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "p"=>"project" ) );
    if( $onlyEnabled ) $select->where($db->quoteInto( 'p.enabled=?', 1 ));

    return Zend_Paginator::factory( $select );

}

function db_project_one( $id ){

	if( $id == "" ) return null;

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "p"=>"project" ) );
    $select->where($db->quoteInto( 'p.id=?', $id ));

    $stmt = $db->query( $select);
    $result = $stmt->fetch();

    return $result;
}