<?php

function db_meeting_list( $project_id = null ){

    $db = DBLOADER::getApp();
    $select = $db->select();

    $select->from( array( "m"=>"meetings" ) );
    $select->where($db->quoteInto( 'm.project_id=?', $project_id ));
    $select->order(array( "open_date DESC"));

    return Zend_Paginator::factory( $select );

}

function db_meeting_one( $id ){

	if( empty($id) ) return array();

    $db = DBLOADER::getApp();
    $select = $db->select();

    $select->from( array( "m"=>"meetings" ) );
    $select->where($db->quoteInto( 'm.id=?', $id ));

    $stmt = $db->query( $select);
    return $stmt->fetch();

}

function db_meeting_issues( $meeting_id ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "mi"=>"meeting_issues" ) );
    $select->where($db->quoteInto( 'mi.meeting_id=?', $meeting_id ) );
    $select->join( array( "i"=>"issues"), "mi.issue_id = i.id", array( "issue_id" => "id" , "title", "deadline", "priority", "description" ) );

    return Zend_Paginator::factory( $select );
}

function db_meeting_tasks( $meeting_id ){

	$db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "mi"=>"meeting_issues" ) );
    $select->where($db->quoteInto( 'mi.meeting_id=?', $meeting_id ) );
    $select->join( array( "i"=>"issues"), "mi.issue_id = i.id" );

    $stmt = $db->query( $select);
    $tmpIssues = $stmt->fetchAll();

    $arIssues = array();
    $arIssues[] = -1;
    foreach( $tmpIssues as $eachIssue )
    {
    	$arIssues[] = $eachIssue['id'];
    }

    $select = $db->select();
    $select->from( array( "t"=>"tasks" ) );
    $select->where( 't.issue_id IN ('. implode( ",", $arIssues ). ')' );

    $stmt = $db->query( $select);
    $tmpTasks = $stmt->fetchAll();

    $arTasks = array();
    foreach( $tmpTasks as $eachTask )
    {
        $arTasks[ $eachTask['issue_id'] ][] = $eachTask;
    }


    return $arTasks;
}