<?php

function db_issues_one( $id ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ) );
    $select->where($db->quoteInto( 'i.id=?', $id ));

    $stmt = $db->query( $select);
    $result = $stmt->fetch();

    $h = db_issues_handler( $id );
    $result['handler'] = $h;

    return $result;
}

function db_issue_categories( $id ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "ic"=>"issue_categories" ) );
    $select->where($db->quoteInto( 'ic.issue_id=?', $id ));

    $stmt = $db->query( $select );
    $result = $stmt->fetchAll();

    return $result;
}

function db_issues_handler( $id ){

	$db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "h"=>"handleuser" ) );
    $select->where($db->quoteInto( 'h.issue_id=?', $id ));

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    return $result;
}

function db_issues_list( $project_id = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ) );
    $select->where($db->quoteInto( 'i.project_id=?', $project_id ));

    $select->where($db->quoteInto( 'i.status < ?', 1900 ));

    return Zend_Paginator::factory( $select );

}

function db_issues_list_newarrive( $project_id = null, $status = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "i"=>"issues" ) );
    $select->where($db->quoteInto( 'i.project_id=?', $project_id ));
    if( $status !== null )$select->where($db->quoteInto( 'i.status=?', $status ));
    $select->order(array( "insert_time DESC"));

    return Zend_Paginator::factory( $select );

}

function db_issues_list_mine( $project_id = null, $status = null, $uid = null ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "h"=>"handleuser" ) );

    if( empty( $uid ) )
    {
    	$uid = usess_get_userid();
    }

    $select->where($db->quoteInto( 'h.user_id=?', $uid ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $arIssues = array( -1 );
    foreach( $result as $eachRow )
    {
    	$arIssues[] = $eachRow['issue_id'];
    }

    $select = $db->select();
    $select->from( array( "i"=>"issues" ) );
    $select->where($db->quoteInto( 'i.project_id=?', $project_id ));

    if( $status !== null )$select->where($db->quoteInto( 'i.status=?', $status ));

    $select->where($db->quoteInto( 'i.status < ?', 1900 ));

    $select->where('i.id IN ( '. implode( ",", $arIssues). ')' );
    $select->order(array( "status ASC", "insert_time DESC") );

    return Zend_Paginator::factory( $select );

}

function db_issues_search( $project_id, $params ){

    $db = DBLOADER::getApp();

    $select = $db->select();
    $select->from( array( "h"=>"handleuser" ) );

//    $select->where($db->quoteInto( 'h.user_id=?', usess_get_userid() ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();

    $arIssues = array( -1 );
    foreach( $result as $eachRow )
    {
        $arIssues[] = $eachRow['issue_id'];
    }

    $select = $db->select();
    $select->from( array( "i"=>"issues" ) );
    $select->where($db->quoteInto( 'i.project_id=?', $project_id ));

//    $select->where('i.id IN ( '. implode( ",", $arIssues). ')' );
    if( $params['status'] !== null )$select->where($db->quoteInto( 'i.status=?', $params['status'] ) );

    if( $params['issue_status'] !== null )
    {
    }
    else
    {
    	$select->where($db->quoteInto( 'i.status < 1400 ', "" ) );
    }

    if( $params['issue_category'] != "" )
    {
    	$select2 = $db->select();
    	$select2->from( array( "c"=>"issue_categories" ) );
    	$select2->where($db->quoteInto( 'c.category_id IN (?)', is_array( $params['issue_category'] ) ? implode( ',', $params['issue_category'] ) : $params['issue_category'] ) );
    	$stmt = $db->query( $select2 );
    	$result2 = $stmt->fetchAll();

    	$arIssues = array();
    	foreach( $result2 as $eachIssue )
    	{
            $arIssues[ $eachIssue['issue_id' ] ] = $eachIssue['issue_id'];
    	}

    	$select->where( ' i.id IN ( '. implode( ',', $arIssues ).' )' ) ;
    }
    if( $params['phenomenon_type'] != ""  )$select->where($db->quoteInto( 'i.phenomenon_type=?', $params['phenomenon_type'] ) );
    if( $params['priority'] !== null  )$select->where($db->quoteInto( 'i.priority=?', $status ) );
    if( $params['severity'] !== null  )$select->where($db->quoteInto( 'i.severity=?', $status ) );
    if( $params['scale'] !== null     )$select->where($db->quoteInto( 'i.scale=?', $status ) );

    if( $params['keyword'] !== null  )$select->where($db->quoteInto( 'i.title LIKE ? OR i.description LIKE ?', "%". str_replace( array( "%", "_" ), array( '\%', '\_' ), $params['keyword'] ). "%" ) );

//    $select->where($db->quoteInto( 'i.status < ?', 1900 ));

    return Zend_Paginator::factory( $select );

}
