<?php

require_once( "Zend/Paginator.php" );
require_once( "Zend/Paginator/Adapter/Array.php" );
require_once( "Zend/Paginator/ScrollingStyle/Sliding.php" );
require_once( "Zend/View/Helper/PaginationControl.php" );

function db_common_now( $db ){

	$cName = strtolower( get_class( $db ) );

	switch( true )
	{
		case preg_match( '/pgsql/', $cName ):
			return date( "Y-m-d H:i:s" );
			break;

		case preg_match( '/oci/', $cName ):
		case preg_match( '/ora/', $cName ):
			return date( "Y-m-d H:i:s" );
			break;

		case preg_match( '/mysql/', $cName ):
		default:
            return date( "Y-m-d H:i:s" );
			break;
	}
}

/**
 *
 * @param  Mix $strDate
 * @param  String $default Return this string when {$strDate} is null.
 * @return Array
 */
function db_common_convdate( $strDate, $default=null ){

//	if( is_array( $strDate ) && $strDate["Y"] != "" && $strDate["M"] != "" && $strDate["D"] != "")
	if( is_array( $strDate ) )
	{
		return db_common_convdate2( $strDate, $default );
	}

	$retArray = array();
    if( $strDate == null || $strDate == "0000-00-00 00:00:00" || $strDate == "0000-00-00" ) return $default;

	$retArray["Y"] = date( "Y", strtotime( $strDate ) );
	$retArray["M"] = date( "m", strtotime( $strDate ) );
	$retArray["D"] = date( "d", strtotime( $strDate ) );

	return $retArray;
}

function db_common_convdate2( Array $date, $default=null ){

    return sprintf( '%s-%s-%s 00:00:00', $date["Y"], $date["M"], $date["D"] );
}

function db_common_convtime( $strTime, $default=null ){

    if( is_array( $strTime ) )
    {
        return db_common_convtime2( $strTime, $default );
    }

	if( preg_match( "/^[0-2][0-9][0-5][0-9]$/", $strTime ) )
	{
        return db_common_convtime3( $strTime, $default );
	}

    $retArray = array();
    if( $strTime == null ) return $default;

    $retArray["H"] = date( "H", strtotime( $strTime ) );
    $retArray["I"] = date( "I", strtotime( $strTime ) );

    return $retArray;
}

function db_common_convtime2( Array $time, $default=null ){

    return str_pad( $time["H"], 2, 0, STR_PAD_LEFT ) . str_pad( $time["I"], 2, 0, STR_PAD_LEFT );
}

function db_common_convtime3( $strTime, $default=null ){

    $retArray["H"] = substr( $strTime, 0, 2 );
    $retArray["I"] = substr( $strTime, 2, 2 );

    return $retArray;
}

