<?php

function db_comments_list( $meeting_id = null, $issue_id = null ){

	if( is_null( $meeting_id) && is_null( $issue_id ) ) return Array();

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "cmt"=>"comments" ) );
    if( $issue_id ) $select->where($db->quoteInto( 'cmt.issue_id=?', $issue_id ));
    if( $meeting_id ) $select->where($db->quoteInto( 'cmt.meeting_id=?', $meeting_id ));

    $select->order( array( "update_time DESC" ) );

    $stmt = $db->query( $select );
    $result = $stmt->fetchAll();

    return $result;
}