<?php


function db_categories_list( $projectId, $onlyEnabled=true ){

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "c"=>"categories" ) );
    $select->where($db->quoteInto( 'c.project_id=?', $projectId ));
    if( $onlyEnabled ) $select->where($db->quoteInto( 'c.enabled=?', 1 ));

    $select->order( array( "enabled DESC" ) );

    $stmt = $db->query( $select);
    $result = $stmt->fetchAll();
    return $result;
}

function db_category_one( $id ){

    if( $id == "") throw new Exception();

    $db = DBLOADER::getApp();

    $select = $db->select();

    $select->from( array( "c"=>"categories" ) );
    $select->where($db->quoteInto( 'c.id=?', $id ) );

    $stmt = $db->query( $select );
    $result = $stmt->fetch();
    return $result;

}