<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

class User_RemindController extends User_IndexController
{
	protected $public = true;

	public function extValidate( $name, $value, $action, $request ){

		if( $action == 'pweditcomplete' )
		{
			if( $name == 'password' && $value != $request['repassword'] )
			{
				return array( "password does not match" );
			}
		}

		return true;
	}

    public function indexAction(){

    	$req = $this->getRequest();
    	$this->setRequest( $req );

    	$this->_forward( "add" );
    }

    public function remindcancelAction(){

        $this->view->assignLang( "pagename", "Remind Cancel" );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        if( ! db_user_repassword( $req['uid'], $req['key'] ) ){

            throw new Exception();
        }

        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"members", "db"=>$db ) );

        $data = array(
            'pwremind_ticket'   => '',
            'update_time'  => null
        );

        $where = $table->getAdapter()->quoteInto('id=?', $req['uid'] );
        $where .= $table->getAdapter()->quoteInto(' AND pwremind_ticket=?', $req['key'] );

        $cnt = $table->update( $data, $where );

    }


    public function pweditAction(){

    	$this->view->assign( "nextaction", "pweditcomplete" );
    	$this->view->assignLang( "pagename", "Password registration" );

    	$req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        if( ! db_user_repassword( $req['uid'], $req['key'] ) ){

        	throw new Exception();
        }
    }

    public function pweditcompleteAction(){

    	$config = new Zend_Config_Ini( "common/validation/user.ini" , 'confirm' );
        $form   = new Ext_Form( $config->user->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

    	$this->view->assignLang( "pagename", "Password registration" );

    	$p = array( "password", "uid" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "pwedit" );
            return;
        }

        // regist data

        $pw = md5( $req['password'] );

        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"members", "db"=>$db ) );

        $data = array(
            'password'          => $pw,
            'pwremind_ticket'   => '',
            'update_time'       => null
        );

        $where = $table->getAdapter()->quoteInto('id=?', $req['uid'] );
        $where .= $table->getAdapter()->quoteInto(' AND pwremind_ticket=?', $req['key'] );

        $cnt = $table->update( $data, $where );

        if( $cnt == 0 )
        {
        	throw new Exception();
        }
    }

}