<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

class User_RegistController extends User_IndexController
{

	public function appinit(){

		if( $this->isNotAdmin() )
		{
			$this->_redirect( "top" );
		}

	}

	public function extValidate( $name, $value, $action, $request ){

		switch( $action )
		{
			case "confirm":
			case "complete":

				if( $name == "password" && $request["userself"] == 1  ) return "skip";
				if( $name == "username")
				{
					$dpl = db_user_isduplicate( $value, $request['uid'] );
					if( $dpl ) return array( "user already registed" );
				}
				break;
			case "editconfirm":
			case "editcomplete":
                if( $name == "password" && $request["password"] == ""  ) return "skip";
				break;
			default:
		}

		return true;
	}

    public function indexAction(){

    	$req = $this->getRequest();
    	$req->setParam( "userself", 1 );
    	$this->setRequest( $req );

    	$this->_forward( "add" );
    }

    public function addAction(){

    	$this->view->assign( "nextaction", "confirm" );
    	$this->view->assignLang( "pagename", "Add user" );

    	$req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );
    }

    public function editAction(){

        $req = $this->getRequest()->getParams();

        $row = db_user_one( $req['uid'] );

        $this->view->assign( "nextaction", "editconfirm" );
        $this->view->assignLang( "pagename", "Edit user" );

        $d = array(
            "username" => $row['username'],
            "realname" => $row['realname'],
            "email"    => $row['email'],
            "authority" => $row['authority']
        );

        $this->view->assignRequest( array_merge($d, $req ) );

    }

    public function confirmAction(){

    	$config = new Zend_Config_Ini( "common/validation/user.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->user->regist );

    	$req = $this->getRequest()->getParams();
    	$this->view->assignRequest( $req );

    	$p = array( "username", "password", "realname", "email", "authority" );

    	$form->validateAll( $this, $p, $req );

    	$errorExist = $form->errorExist();

    	if( $errorExist ){
    		$this->_forward( "add" );
    		return;
    	}

    	$this->view->assign( "nextaction", "complete" );
    }

    public function editconfirmAction(){

        $config = new Zend_Config_Ini( "common/validation/user.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->user->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "username", "password", "realname", "email", "authority" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "edit" );
            return;
        }

        $this->view->assign( "nextaction", "editcomplete" );
    }


    public function completeAction(){

    	$config = new Zend_Config_Ini( "common/validation/user.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->user->regist );

        $req = $this->getRequest()->getParams();
        $this->view->assignRequest( $req );

        $p = array( "username", "password", "realname", "email", "authority" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        // regist database

        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"members", "db"=>$db ) );

        $key = '';
        if( $req['userself'] == 1 )
        {
        	$key = md5( microtime() );
        	$this->view->assign( "key", $key );
        }

        $pw = "";
        if( strlen( $req['password'] ) > 0 )
        {
        	$pw = md5( $req['password'] );
        }

        $data = array(
            'username'        => $req['username'],
            'realname'        => $req['realname'],
            'authority'       => $req['authority'],
            'email'           => $req['email']
        );

        if( strlen( $req['password'] ) > 0 )
        {
	        $data['password'] = $pw;
        }

        if( $req['uid'] != "" )
        {
        	$where = $table->getAdapter()->quoteInto('id=?', $req['uid'] );
        	$table->update( $data, $where );
        }
        else
        {
        	// additional columns
        	$data['pwremind_ticket'] = $key;
        	$data['enabled'] = 1;

	        $table->insert( $data );
        }
        $uid = $db->lastInsertId();

        $this->view->assign( "userid", $uid );

        $this->render( "complete" );
    }

    public function editcompleteAction(){

    	$this->completeAction();
    }

    public function remindrequestAction(){

        $req = $this->getRequest()->getParams();

        if( $req['uid'] == "" ) $this->_redirect("/");

        $key = md5( microtime() );
        $this->view->assign( "key", $key );

        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"members", "db"=>$db ) );

        $data = array(
            'pwremind_ticket'   => $key
        );

        $where = $table->getAdapter()->quoteInto('id=?', $req['uid'] );

        $cnt = $table->update( $data, $where );

        $this->view->assign( "userid", $req['uid'] );
    }


}