<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "IndexController.php" );

require_once( "Zend/Paginator.php" );
require_once( "Zend/Paginator/Adapter/Array.php" );
require_once( "Zend/Paginator/ScrollingStyle/Sliding.php" );
require_once( "Zend/View/Helper/PaginationControl.php" );

class User_RefController extends User_IndexController
{

	public function appinit(){

        if( $this->isNotAdmin() )
        {
            $this->_redirect( "top" );
        }

    }

    public function indexAction(){

    	$this->_forward( "userlist" );
    }

    public function userlistAction(){

    	$req = $this->getRequest()->getParams();

    	$paginator = db_user_list();

    	$paginator->setCurrentPageNumber( $req['page'] );
        $paginator->setItemCountPerPage( 10 );

        $paginator->setView( $this->view );

        $this->view->assign( "paginator", (array) $paginator->getPages() );

        $arItem = $paginator->getCurrentItems();

        $this->view->assign( "userlist" , $arItem->getArrayCopy() );

        $this->view->assignLang( "usercount", "%s users", $paginator->getTotalItemCount() );
        $this->view->assignLang( "pagename" , "list of users" );
    }

}