<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

class Task_RegistController extends Task_IndexController
{

    public function extValidate( $name, $value, $action, $request ){

        switch( $action )
        {
            case "starteditconfirm":

                if( $name == "deadline" && $value['M'] == "" && $value['D'] == "" && $value['Y'] == "" ) return "skip";

                if( $name == "deadline" )
                {
                    $ret = array();
                    if( ! checkdate( intval( $value['M'] ), intval( $value['D'] ), intval( $value['Y'] ) ) )
                    {
                        $ret[] = "invalid date";
                        return $ret;
                    }
                }

                break;
            default:
        }

        return true;
    }


    public function indexAction(){
        // action body
        $this->_forward( "myview" );
    }

    public function addAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "Add Task" );
        $this->view->assign("nextaction", "add" );
        $this->view->assign( "includescript", array( "task.add.js" ) );

        $config = new Zend_Config_Ini( "common/validation/task.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $p = array( "project_id", "issue_id" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            throw new Exception();
            return;
        }

        if( $req['title'] && $req['project_id'] && $req['issue_id'] )
        {
        	// regist database
        	$db = DBLOADER::getApp();

        	$table = new Ext_Db_Table( array( "name"=>"tasks", "db"=>$db ) );

        	$data = array(
	            'title'             => $req['title'],
	            'issue_id'          => $req['issue_id'],
        	    'version'           => 1,
        	    'status'            => 1100
        	);

        	$table->insert( $data );
        	$this->_redirect( "task/regist/add?project_id=". $req['project_id']."&issue_id=". $req['issue_id']. "&uid=". $req['uid'] );
        	return;
        }

        if( $req['project_id'] && $req['issue_id'] && $req['id'] && $req['status'] )
        {

        	// regist database
        	$db = DBLOADER::getApp();

        	$table = new Ext_Db_Table( array( "name"=>"tasks", "db"=>$db ) );


        	$data = array(
        	    'status'            => $req['status']
        	);

        	if( $req['status'] == 1500 )
        	{
        		$data['progress'] = 100;
        	}

        	$where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
        	$table->update( $data, $where. $where2 );

        	$this->_redirect( "task/regist/add?project_id=". $req['project_id']."&issue_id=". $req['issue_id']. "&uid=". $req['uid'] );
        	return;
        }

        $d['issue'] = db_issues_one( $req['issue_id'] );
        $d['tasks'] = db_task_list( $req['issue_id'] );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function updatetaskAction(){

    	$config = new Zend_Config_Ini( "common/validation/task.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();

        $p = array( "id", "issue_id", "description", "deadline", "estimate", "cost", "progress" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
        	$this->_forward( "add" );
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"tasks", "db"=>$db ) );

        $data = array(
            "description"   => $req['description'] ,
            "deadline"      => db_common_convdate( $req['deadline'] ),
            "estimate"      => $req['estimate'],
            "cost"          => $req['cost'],
            "progress"      => $req['progress'],
            "version"       => $req['version'] + 1
        );

        switch( true )
        {
        	case $req['progress'] >= 100:
        		$data['status'] = 1500;
        		break;

        	case $req['status'] == 1100 && $req['progress'] == 0:
        		break;

        	case $req['progress'] >= 0;
        	   $data['status'] = 1300;
        	   break;
        }

        $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
        $where2 = $table->getAdapter()->quoteInto(' AND version=?', $req['version'] );
        $table->update( $data, $where. $where2 );

        $this->_redirect( "task/regist/add?project_id=". $req['project_id']."&issue_id=". $req['issue_id']. "&id=". $req['id']. "&uid=". $req['uid'] );
    }


}