<?php

require_once( "Zend/Config/Ini.php" );
require_once( "Zend/Form.php" );
require_once( "library/Ext/Form.php" );

require_once( "Zend/Db/Table.php" );
require_once( "library/Ext/Form.php" );
require_once( "library/Ext/Db/Table.php" );

require_once( "IndexController.php" );

class Task_RefController extends Task_IndexController
{

    public function indexAction(){
        // action body
        $this->_forward( "myview" );
    }

    public function myviewAction(){

        $req = $this->getRequest()->getParams();
        $this->view->assignLang( "pagename" , "My Task" );
        $this->view->assign( "includescript", array( "task.add.js" ) );

        $config = new Zend_Config_Ini( "common/validation/task.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        if( $req['issue_id'] && $req['id'] && $req['status'] )
        {

        	$p = array( "issue_id", "status" );

        	$form->validateAll( $this, $p, $req );

        	$errorExist = $form->errorExist();

        	if( $errorExist ){
        		throw new Exception();
        		return;
        	}

        	// regist database
        	$db = DBLOADER::getApp();

        	$table = new Ext_Db_Table( array( "name"=>"tasks", "db"=>$db ) );


        	$data = array(
                'status'            => $req['status']
        	);

        	if( $req['status'] == 1500 )
        	{
        		$data['progress'] = 100;
        	}

        	$where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
        	$table->update( $data, $where. $where2 );

        	$this->_redirect( "task/ref/myview?project_id=". $req['project_id']."&issue_id=". $req['issue_id']. "&uid=". $req['uid'] );
        	return;
        }

        $params = $req;

        $session = Zend_Registry::get( "sess" );
        if( $req['smr_status'] )
        {
        	$params['status'] = $req['smr_status'];
        	$session->task_myview_summary_status = $params['status'];
        }
        else
        {
        	$params['status'] = $session->task_myview_summary_status;
        }

        $d['tasks'] = db_task_search_mine( $params, $req['uid'] );

        $status_total = db_summary_tasks_status_total_mine( usess_selected_project(), null, $req['uid'] );
        $this->view->assign( "status_total", $status_total );

        $this->view->assignRequest( array_merge($d, $req ) );
    }

    public function updatetaskAction(){

        $config = new Zend_Config_Ini( "common/validation/task.ini" , $this->_request->getActionName() );
        $form   = new Ext_Form( $config->form1->regist );

        $req = $this->getRequest()->getParams();

        $p = array( "id", "issue_id", "description", "deadline", "estimate", "cost", "progress" );

        $form->validateAll( $this, $p, $req );

        $errorExist = $form->errorExist();

        if( $errorExist ){
            $this->_forward( "add" );
            return;
        }

        // regist database
        $db = DBLOADER::getApp();

        $table = new Ext_Db_Table( array( "name"=>"tasks", "db"=>$db ) );

        $data = array(
            "description"   => $req['description'] ,
            "deadline"      => db_common_convdate( $req['deadline'] ),
            "estimate"      => $req['estimate'],
            "cost"          => $req['cost'],
            "progress"      => $req['progress'],
            "version"       => $req['version'] + 1
        );

        switch( true )
        {
            case $req['progress'] >= 100:
                $data['status'] = 1500;
                break;

            case $req['status'] == 1100 && $req['progress'] == 0:
                break;

            case $req['progress'] >= 0;
               $data['status'] = 1300;
               break;
        }

        $where = $table->getAdapter()->quoteInto('id=?', $req['id'] );
        $where2 = $table->getAdapter()->quoteInto(' AND version=?', $req['version'] );
        $table->update( $data, $where. $where2 );

        $this->_redirect( "task/ref/myview?project_id=". $req['project_id']."&issue_id=". $req['issue_id']. "&id=". $req['id']. "&uid=". $req['uid'] );
    }


}